% 2010-11-04 Magnus Burenius

% Reflect the reconstruction if necessary to get left and right right.
% Assumes that the reconstruction is of a person and computes determinants
% of some specific joints to get the order structure.

% C number of cameras. Assumes C >= 3.
% N number of reconstructed points.

% P 2Cx3 matrix. The affine camera matrices stacked on top of each other.
% X 3xN  matrix. The reconstructed 3D points.

function [P1 X1] = Reflect( P, X )

JL = JointLabels();

% Compute measures of 4-determinants that should be positive:

% Left leg:
t = X(:,JL('L_ANKLE'));
u = X(:,JL('L_KNEE' ));
v = X(:,JL('L_HIP'  ));
w = X(:,JL('R_HIP'  ));
m = [   t u v w  ;
        1 1 1 1 ];
leftLeg = -sign(det( m ));

% Right leg:
t = X(:,JL('R_ANKLE'));
u = X(:,JL('R_KNEE' ));
v = X(:,JL('R_HIP'  ));
w = X(:,JL('L_HIP'  ));
m = [   t u v w  ;
        1 1 1 1 ];
rightLeg = +sign(det( m ));

% Left arm:
t = X(:,JL('L_WRIST'   ));
u = X(:,JL('L_ELBOW'   ));
v = X(:,JL('L_SHOULDER'));
w = X(:,JL('R_SHOULDER'));
m = [   t u v w  ;
        1 1 1 1 ];
leftArm = +sign(det( m ));

% Right arm:
t = X(:,JL('R_WRIST'   ));
u = X(:,JL('R_ELBOW'   ));
v = X(:,JL('R_SHOULDER'));
w = X(:,JL('L_SHOULDER'));
m = [   t u v w  ;
        1 1 1 1 ];
rightArm = -sign(det( m ));

if( leftLeg + rightLeg + leftArm + rightArm > 0 )
    P1 = P;
    X1 = X;
else % Reflect if the determinants does not have the expected signs:
    R = [   1 0  0  ;
            0 1  0  ;
            0 0 -1 ];
    % N.B: inv(R)=R
    P1 = P * R;
    X1 = R * X;
end

end


