% 2013-08-19 Magnus Burenius

% Performs affine factorization

% C number of cameras
% N number of points

% The points are assumed to be zero-mean in each 2D and 3D coordinate
% system.

% W     2CxN    The measurement matrix.
% M     2Cx3    The reconstructed 2x3 affine camera matrices,
%               stacked on top of each other.
% X     3xN     The reconstructed 3D points.

function [M X] = AffineFactorization( W )

% Factorize using SVD:
[U,S,V] = svd( W );

% Truncate to get rank 3:
M(:,:) = U(:,1:3) * S(1:3,1:3);
X(:,:) = V(:,1:3)';

end

