% 2013-08-16 Magnus Burenius

% Draw the annotation on top of the images for a single frame
% and the 3D reconstruction.

clear all
close all

dataDir = '../Player 2/Sequence 1/';
frame = 175;
CAMERAS = 3;
LANDMARKS = 14;

% Load 2D annotation:
x = load( [dataDir 'positions2d.txt'] );
FRAMES = length(x) / 2 / LANDMARKS / CAMERAS;
positions2d = reshape( x, 2, LANDMARKS, CAMERAS, FRAMES );

% Load 3D reconstruction of joints:
x = load( [dataDir 'positions3d.txt'] );
FRAMES = length(x) / 3 / LANDMARKS;
positions3d = reshape( x, 3, LANDMARKS, FRAMES );

% Load 3D reconstruction of cameras:
x = load( [dataDir 'cameras.txt'] );
FRAMES = length( x ) / 2 / 4 / CAMERAS;
cameras = reshape( x, 2, 4, CAMERAS, FRAMES );

% Load images for a single frame:
images = cell(CAMERAS,1);
for c=1:CAMERAS
    s = sprintf( '%sCamera %i/%05i.png', dataDir, c, frame );
    images{c} = imread( s );   
end

% Re-project 3D reconstruction:
positions2dReprojected = zeros( 2, LANDMARKS, CAMERAS, FRAMES );
for t=1:FRAMES
    for c=1:CAMERAS
        positions2dReprojected(:,:,c,t) = ...
            cameras(:,:,c,t) * [positions3d(:,:,t); ones(1,LANDMARKS)];
    end
end

% Define skeleton model for visualization:
bones = zeros(LANDMARKS,LANDMARKS);
JL = JointLabels();
bones( JL('L_ANKLE'    ), JL('L_KNEE'    ) ) = 1;
bones( JL('L_KNEE'     ), JL('L_HIP'     ) ) = 1;
bones( JL('L_HIP'      ), JL('R_HIP'     ) ) = 1;
bones( JL('R_HIP'      ), JL('R_KNEE'    ) ) = 1;
bones( JL('R_KNEE'     ), JL('R_ANKLE'   ) ) = 1;
bones( JL('L_WRIST'    ), JL('L_ELBOW'   ) ) = 1;
bones( JL('L_ELBOW'    ), JL('L_SHOULDER') ) = 1;
bones( JL('L_SHOULDER' ), JL('R_SHOULDER') ) = 1;
bones( JL('R_SHOULDER' ), JL('R_ELBOW'   ) ) = 1;
bones( JL('R_ELBOW'    ), JL('R_WRIST'   ) ) = 1;
bones( JL('L_HIP'      ), JL('L_SHOULDER') ) = 1;
bones( JL('R_HIP'      ), JL('R_SHOULDER') ) = 1;
bones( JL('BOTTOM_HEAD'), JL('TOP_HEAD'  ) ) = 1;
bones = bones + bones';

%% Draw 2D annotation and re-projected reconstruction on top of images:

figure
for c=1:CAMERAS
    subplot( 1, CAMERAS, c )
    hold on
    imshow( images{c} )
    
    x1 = positions2d(1,:,c,frame);
    y1 = positions2d(2,:,c,frame);

    x2 = positions2dReprojected(1,:,c,frame);
    y2 = positions2dReprojected(2,:,c,frame);
    
    % Draw all joints:
    plot( x1, y1, 'or' )
    plot( x2, y2, 'oy' )
    
    % Draw all bones:
    for i = 1:LANDMARKS
       for j = i:LANDMARKS
           if( bones(i,j) )
               plot( [x1(i) x1(j)], [y1(i) y1(j)], '-r' )
               plot( [x2(i) x2(j)], [y2(i) y2(j)], '-y' )
           end
       end
    end
end

%% Plot reconstructed 3D pose:

figure
hold on

x = positions3d( 1, :, frame );
y = positions3d( 2, :, frame );
z = positions3d( 3, :, frame );

% Draw all joints:
plot3( x, y, z, 'o' )

% Draw all bones:
for i = 1:LANDMARKS
   for j = i:LANDMARKS
       if( bones(i,j) )
           plot3( [x(i) x(j)], [y(i) y(j)], [z(i) z(j)] )
       end
   end
end

axis equal
axis( [-1 1 -1 1 -1 1 -1 1] )
grid on
view(-30,24)

