% [acc]  = forward_dynamics(robot, tp, trq, pos1, pos2) gives
% acceleration vector
% [acc, MAT, tau]  = forward_dynamics(robot, tp, trq, pos1, pos2) gives
% acceleration vector acc and matrix MAT and vector tau such that 
% trq = MAT*acc + tau

function [acc, M, tau] = forward_dynamics(robot, tp, trq, pos1, pos2)

grav = [0 0 0]';

M=zeros(6,6);

for k=1:6
  dp2_ddt = zeros(6,1);
  dp2_ddt(k)=1;
  [f, n, t] = dynamics(robot, zeros(6,1), dp2_ddt, pos1, pos2, grav);
  M(k,:)= t(:)';
end

dp2_ddt = zeros(6,1);
[f, n, t] = dynamics(robot, tp, dp2_ddt, pos1, pos2);
tau = t(:);

acc = inv(M)*(trq-tau);