//
// You received this file as part of MCA2
// Modular Controller Architecture Version 2
//
//Copyright (C) Forschungszentrum Informatik Karlsruhe
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// this is a -*- C++ -*- file
//----------------------------------------------------------------------
/*!\file    AutoDemoController.h
 *
 * \author   Christian Smith
 * \date    09.05.05
 *
 * $Revision: 1.7 $
 * $Id: NullModule.h,v 1.7 2003/02/24 14:36:21 gassmann Exp $
 *
 * \brief   Contains mAutoDemoController
 *
 * \b mAutoDemoController
 *
 * A few words for mAutoDemoController
 *
 */
//----------------------------------------------------------------------

#ifndef _AutoDemoController_h_
#define _AutoDemoController_h_
//----------------------------------------------------------------------
// System Includes - include with <>
//----------------------------------------------------------------------
// z.B. #include <stdio.h>
#include <Module.h>
#include <descr.h>
//----------------------------------------------------------------------
// Project Includes - include with ""
//----------------------------------------------------------------------

//----------------------------------------------------------------------
// Extern methods and global vars
//----------------------------------------------------------------------

//----------------------------------------------------------------------
// Forward class declarations
//----------------------------------------------------------------------

//----------------------------------------------------------------------
// Implementation
//----------------------------------------------------------------------

//! Short description of mAutoDemoController
/*! 
  This module sends new sets of predefined position parameters at 
  a predefined time interval.
*/
class mAutoDemoController:public tModule
{
 public:
  /*!
    Anonymous enumeration typ which contains the indices of the
    controller inputs.
  */
  
  
  _DESCR(mAutoDemoController::ci_description,4,Natural,cDATA_VECTOR_END_MARKER);
  enum {
    eCI_TOOL_X,   /*! X-Coordinate of the position-vector */
    eCI_TOOL_Y,   /*! Y-Coordinate of the position-vector */
    eCI_TOOL_Z,   /*! Z-Coordinate of the position-vector */
    eCI_TOOL_O,   /*! Orientation angle of the tool [rad] */
    eCI_TOOL_A,   /*! Altitude angle of the tool [rad]    */
    eCI_TOOL_T,   /*! Tool angle of the tool [rad]        */
    eCI_ARM,      /*! Switch for the arm-orientation [left/right]    */
    eCI_ELBOW,    /*! Switch for the elbow-orientation [above/below] */
    eCI_WRIST,    /*! Switch for the wrist-orientation [down/up]     */
    eCI_FLIP,     /*! Toggle the other way round */
    eCI_DIMENSION /*!< Endmarker and Dimension */
  };
  
  /*!
    Anonymous enumeration typ which contains the indices of the
    controller outputs.
  */
  _DESCR(mAutoDemoController::co_description,4,Natural,cDATA_VECTOR_END_MARKER);
  enum {
    eCO_TOOL_X,   /*! X-Coordinate of the position-vector */
    eCO_TOOL_Y,   /*! Y-Coordinate of the position-vector */
    eCO_TOOL_Z,   /*! Z-Coordinate of the position-vector */
    eCO_TOOL_O,   /*! Orientation angle of the tool [rad] */
    eCO_TOOL_A,   /*! Altitude angle of the tool [rad]    */
    eCO_TOOL_T,   /*! Tool angle of the tool [rad]        */
    eCO_ARM,      /*! Switch for the arm-orientation [left/right]    */
    eCO_ELBOW,    /*! Switch for the elbow-orientation [above/below] */
    eCO_WRIST,    /*! Switch for the wrist-orientation [down/up]     */
    eCO_FLIP,     /*! Toggle the other way round */
    eCO_DIMENSION /*!< Endmarker and Dimension */
  };
  
  /*!
    Anonymous enumeration typ which contains the indices of the
    sensor inputs.
  */
  _DESCR(mAutoDemoController::si_description,4,Natural,cDATA_VECTOR_END_MARKER);
  enum {
    eSI_DIMENSION /*!< Endmarker and Dimension */
  };
  
  /*!
    Anonymous enumeration typ which contains the indices of the
    sensor outputs.
  */
  _DESCR(mAutoDemoController::so_description,4,Natural,cDATA_VECTOR_END_MARKER);
  enum {
    eSO_DIMENSION /*!< Endmarker and Dimension */
  };
  
  /*!
    Anonymous enumeration typ which contains the indices of the
    parameters.
  */
  enum {
    ePAR_BOOL, /*!< Index of Parameter Dummy1 */
    ePAR_INT, /*!< Index of Parameter Dummy2 */
    ePAR_FLOAT, /*!< Index of Parameter Dummy3 */
    ePAR_STRING, /*!< Index of Parameter Dummy4 */
    ePAR_DIMENSION /*!< Endmarker and Dimension */
  };
  
  
  /*!
    Descriptions of the controller inputs
  */
  static const tDescription ci_description[];
  /*!
    Descriptions of the controller outputs
  */
  static const tDescription co_description[];
  /*!
    Descriptions of the sensor inputs
  */
  static const tDescription si_description[];
  /*!
    Descriptions of the sensor outputs
  */
  static const tDescription so_description[];
  
  
  /*! \param parent the parent
   *  \param name The module name
   *  \param fixit whether to use FixIt() or not
   */
  mAutoDemoController(tParent *parent,
		      tDescription name="AutoDemoController",bool fixit=true);
  /*!
   */
  ~mAutoDemoController();
  /*!
   */
  void Control();
  /*!
   */
  void Sense();
  /*!
   */
  void Exception(tExceptionType type);
  
  void ADC_initializePoints(void);
  
 private:
  
#define ADC_NUMBER_OF_POINTS 30
#define ADC_PERIOD (0.005)
  int ADC_pointcounter;
  int ADC_startupcounter;
  tTime ADC_sense_timer;
  double ADC_point[ADC_NUMBER_OF_POINTS][eCO_DIMENSION];
  
};

#endif //#ifndef _AutoDemoController_h_
