// this is a -*- C++ -*- file
//----------------------------------------------------------------------
/*!\file    JointSimulation2.h
 *
 * \author   Kay-Ulrich Scholl
 * \date    06.11.02
 *
 * $Revision: 1.1 $
 * $Id: JointSimulation2.h,v 1.1 2002/11/06 15:17:54 scholl Exp $
 *
 * \brief   Contains tJointSimulation2
 *
 * \b tJointSimulation2
 *
 * A few words for tJointSimulation2
 *
 */
//----------------------------------------------------------------------

#ifndef _JointSimulation2_h_
#define _JointSimulation2_h_
//----------------------------------------------------------------------
// System Includes - include with <>
//----------------------------------------------------------------------
// z.B. #include <stdio.h>
#include <Module.h>
#include <descr.h>
//----------------------------------------------------------------------
// Project Includes - include with ""
//----------------------------------------------------------------------

//----------------------------------------------------------------------
// Extern methods and global vars
//----------------------------------------------------------------------

//----------------------------------------------------------------------
// Forward class declarations
//----------------------------------------------------------------------

//----------------------------------------------------------------------
// Implementation
//----------------------------------------------------------------------

//! Short description of tJointSimulation2
/*! A more detailed description of tJointSimulation2, which
     Kay-Ulrich Scholl hasn't done till now !!
*/
class tJointSimulation2:public tModule
{
public:
  /*!
    Anonymous enumeration typ which contains the indices of the
    controller inputs.
   */
  _DESCR(tJointSimulation2::ci_description,4,Natural,cDATA_VECTOR_END_MARKER)
  enum {
    eCI_JOINT_VALUE, /*!< desired angle value of joint */
    eCI_DIMENSION /*!< Endmarker and Dimension */
  };

  /*!
    Anonymous enumeration typ which contains the indices of the
    controller outputs.
   */
  _DESCR(tJointSimulation2::co_description,4,Natural,cDATA_VECTOR_END_MARKER)
  enum {
    eCO_DIMENSION /*!< Endmarker and Dimension */
  };

  /*!
    Anonymous enumeration typ which contains the indices of the
    sensor inputs.
   */
  _DESCR(tJointSimulation2::si_description,4,Natural,cDATA_VECTOR_END_MARKER)
  enum {
    eSI_DIMENSION /*!< Endmarker and Dimension */
  };

  /*!
    Anonymous enumeration typ which contains the indices of the
    sensor outputs.
   */
  _DESCR(tJointSimulation2::so_description,4,Natural,cDATA_VECTOR_END_MARKER)
  enum {
    eSO_CURRENT_JOINT_VALUE, /*!< simulated joint angle value */
    eSO_DIMENSION /*!< Endmarker and Dimension */
  };

  /*!
    Anonymous enumeration typ which contains the indices of the
    parameters.
   */
  enum {
    ePAR_MIN_ANGLE, /*!< Minimum joint angle */
    ePAR_MAX_ANGLE, /*!< Maximum joint angle */
    ePAR_ANGULAR_VELOCITY, /*!< angular velocity of the joint */
    ePAR_DIMENSION /*!< Endmarker and Dimension */
  };

  /*!
    Descriptions of the controller inputs
  */
  static const tDescription ci_description[];
  /*!
    Descriptions of the controller outputs
  */
  static const tDescription co_description[];
  /*!
    Descriptions of the sensor inputs
   */
  static const tDescription si_description[];
  /*!
    Descriptions of the sensor outputs
   */
  static const tDescription so_description[];
  /*!
   */
  tJointSimulation2(tParent *parent,
	       tDescription name="JointSimulation2",bool fixtit=true);
  /*!
   */
  ~tJointSimulation2();
  /*!
   */
  void Control();
  /*!
  */
  void Sense();
  /*!
   */
  void Exception(tExceptionType type);

 private:
   float new_angle,old_angle;
   float min_angle_value,max_angle_value,angular_velocity;
   tTime sense_timer;
};

#endif
