// this is a -*- C++ -*- file
//----------------------------------------------------------------------
//
//  Written by Christian Smith Apr 29 2005
//  Updated by Christian Smith May 04 2005
//
// Based on file with following credits:
// 
/*!\file    PumaJoints.h
 *
 * \author   Kay-Ulrich Scholl
 * \date    06.11.02
 *
 * $Id: PumaJoints.h,v 1.1 2002/11/06 15:17:54 scholl Exp $
 *
 * \brief   Contains tPumaJoints
 *
 * \b tPumaJoints
 *
 * A few words for tPumaJoints
 *
 */
//----------------------------------------------------------------------

#ifndef _PowerJoints_h_
#define _PowerJoints_h_
//----------------------------------------------------------------------
// System Includes - include with <>
//----------------------------------------------------------------------
#include <Group.h>
#include <descr.h>
//----------------------------------------------------------------------
// Project Includes - include with ""
//----------------------------------------------------------------------

//----------------------------------------------------------------------
// Extern methods and global vars
//----------------------------------------------------------------------

//----------------------------------------------------------------------
// Forward class declarations
//----------------------------------------------------------------------

//----------------------------------------------------------------------
// Implementation
//----------------------------------------------------------------------

//! Short description of tPowerJoints
/*! A more detailed description of tModule_Name, which
     Kay-Ulrich Scholl hasn't done till now !!

    This group uses the following modules:
    \arg A t? Module for ...

*/
class tPowerJoints:public tGroup
{
public:
  /*!
    Anonymous enumeration typ which contains the indices of the
    controller inputs.
   */
  _DESCR(tPowerJoints::ci_description,4,Natural,cDATA_VECTOR_END_MARKER)
  enum {
    eCI_WAIST,
    eCI_SHOULDER,
    eCI_ELBOW,
    eCI_WRIST_ROT,
    eCI_WRIST_BEND,
    eCI_FLANGE,
    eCI_DIMENSION /*!< Endmarker and Dimension */
  };

  /*!
    Anonymous enumeration typ which contains the indices of the
    controller outputs.
   */
  _DESCR(tPowerJoints::co_description,4,Natural,cDATA_VECTOR_END_MARKER)
  enum {
    eCO_DIMENSION /*!< Endmarker and Dimension */
  };

  /*!
    Anonymous enumeration typ which contains the indices of the
    sensor inputs.
   */
  _DESCR(tPowerJoints::si_description,4,Natural,cDATA_VECTOR_END_MARKER)
  enum {
    eSI_DIMENSION /*!< Endmarker and Dimension */
  };

  /*!
    Anonymous enumeration typ which contains the indices of the
    sensor outputs.
   */
  _DESCR(tPowerJoints::so_description,4,Natural,cDATA_VECTOR_END_MARKER)
  enum {
    eSO_WAIST,
    eSO_SHOULDER,
    eSO_ELBOW,
    eSO_WRIST_ROT,
    eSO_WRIST_BEND,
    eSO_FLANGE,

    eSO_WAIST_VEL,
    eSO_SHOULDER_VEL,
    eSO_ELBOW_VEL,
    eSO_WRIST_ROT_VEL,
    eSO_WRIST_BEND_VEL,
    eSO_FLANGE_VEL,

    eSO_WAIST_ACC,
    eSO_SHOULDER_ACC,
    eSO_ELBOW_ACC,
    eSO_WRIST_ROT_ACC,
    eSO_WRIST_BEND_ACC,
    eSO_FLANGE_ACC,

    eSO_WAIST_TRQ,       /*! Torque of the waist-joint [Nm]          */
    eSO_SHOULDER_TRQ,    /*! Torque of the shoulder-joint [Nm]       */
    eSO_ELBOW_TRQ,       /*! Torque of the elbow-joint [Nm]          */
    eSO_WRIST_ROT_TRQ,   /*! Torque of the wrist_rotation-joint [Nm] */
    eSO_WRIST_BEND_TRQ,  /*! Torque of the wrist_bend-joint [Nm]     */
    eSO_FLANGE_TRQ,      /*! Torque of the flange-joint [Nm]         */

    eSO_DIMENSION /*!< Endmarker and Dimension */
  };

  /*!
    Descriptions of the controller inputs
  */
  static const tDescription ci_description[];
  /*!
    Descriptions of the controller outputs
  */
  static const tDescription co_description[];
  /*!
    Descriptions of the sensor inputs
   */
  static const tDescription si_description[];
  /*!
    Descriptions of the sensor outputs
   */
  static const tDescription so_description[];

  /*!
   */
  tPowerJoints(tParent *parent,
	      tDescription name="PowerJoints",bool fixit=true);
  /*!
   */
  ~tPowerJoints();
  /*!
   */
private:
};

#endif
