// <robot_arm_params.h>
// 
// Written by Christian Smith May 03 2005
// Updated by Christian Smith May 03 2005
//
// This headerfile defines some parameters that the
// powercube robot arm uses

#ifndef _ROBOT_ARM_PARAMS_H_
#define _ROBOT_ARM_PARAMS_H_

#include "vectorMath.h"

// Denavit-Hartenberg (mm):
#define PA_DH_A0 (0.0)
#define PA_DH_A1 (0.0)
#define PA_DH_A2 (310.0)
#define PA_DH_A3 (0.0)
#define PA_DH_A4 (0.0)
#define PA_DH_A5 (0.0)

#define PA_DH_D1 (0.0)
#define PA_DH_D2 (0.0)
#define PA_DH_D3 (0.0)
#define PA_DH_D4 (475.0)
#define PA_DH_D5 (0.0)
#define PA_DH_D6 (0.0)
#define PA_DH_TOOL (140.0)

// in radians
#define PA_DH_ALPHA0 (0.0)
#define PA_DH_ALPHA1 (-1.570796326)
#define PA_DH_ALPHA2 (0.0)
#define PA_DH_ALPHA3 (-1.570796326)
#define PA_DH_ALPHA4 (-1.570796326)
#define PA_DH_ALPHA5 (1.570796326)

// some robot parameters
// mass for cubes connected to previous link(kg)
// 0.5 kg added to account for links (simplified)
#define PA_RB_MASS_A1 (2.8 + 0.5)
#define PA_RB_MASS_A2 (2.8 + 0.5)
#define PA_RB_MASS_A3 (2.8 + 0.5)
#define PA_RB_MASS_A4 (0.85 + 0.5)
#define PA_RB_MASS_A5 (0.3 + 0.5)    //0.3
#define PA_RB_MASS_A6 (0.0)

// mass for cubes connected to next link(kg)
#define PA_RB_MASS_B1 (2.8 + 0.5)
#define PA_RB_MASS_B2 (2.8 + 0.5)
#define PA_RB_MASS_B3 (2.8 + 0.5)
#define PA_RB_MASS_B4 (0.85 + 0.5)
#define PA_RB_MASS_B5 (1.5 + 0.5)   //1.5
#define PA_RB_MASS_B6 (0.5 +0.5) // 0.5

// sizes of cubes in [mm]
#define PA_RB_SIZE_1 (110.0)
#define PA_RB_SIZE_2 (110.0)
#define PA_RB_SIZE_3 (110.0)
#define PA_RB_SIZE_4 (70.0)
#define PA_RB_SIZE_5 (70.0)
#define PA_RB_SIZE_6 (70.0)

// Length of link segments [mm]
#define PA_RB_LENGTH_1 (55.0)
#define PA_RB_LENGTH_2 (200.0)
#define PA_RB_LENGTH_3 (45.0)
#define PA_RB_LENGTH_4 (200.0)
#define PA_RB_LENGTH_5 (0.0)
#define PA_RB_LENGTH_6 (70.0)

// Physics (SI units and mm)
#define PA_PH_G 9810.0 


#endif // #ifndef _ROBOT_ARM_PARAMS_H_


