// This program was written by Christian Smith Apr 29 2005
// modified Apr 29 2005
//
// Based on the sourde code "PumaKinematic.C" included in the puma
// tutorial for MCA2

#include "KinematicGroup.h"
#include "Main.h"

void initPartDescription()
{
  SetProgramDescription("\n This Program simulates a PowerCube robot and\n"
			"calculates direct and inverse kinematics.\n");
}

int startup(tPart* part)
{
  tKinematicGroup *powercube=new tKinematicGroup(part);
  if (powercube->Status()==eERROR)
    {
      DEM("Could not create module KinematicGroup\n");
      return -1;
    }
  // Execute as usual
  return part->Execute(tTime().FromMSec(30));
}

void shutdown(tPart* part){}
