#ifndef __tracker
#define __tracker

// How much should we accelerate until we assume we are in motion:
#define ACC_THRESHOLD (1.4)


// how many points do we use to calibrate
#define N_CALIBRATE (500)

// how long is the longest possible motion (in 1/100 secs)
#define MAX_MOTION_LENGTH (500)

/* This function returns the position given a corrected acceleration measure
*/
int acc2pos(double acc_x, // inputs: acceleration in world frame
	    double acc_y,
	    double acc_z,
	    
	    double *pos_x, // outputs: position in world frame
	    double *pos_y,
	    double *pos_z,

	    double *vel_x, // outputs: velocities in world frame
	    double *vel_y,
	    double *vel_z,

	    double *end_x, // outputs: motion enpoint in world frame
	    double *end_y,
	    double *end_z,

	    int reset);

/* This function returns the position given a corrected acceleration measure
*/
int acc2pos2(double acc_x, // inputs: acceleration in world frame
	    double acc_y,
	    double acc_z,
	    
	    double *pos_x, // outputs: position in world frame
	    double *pos_y,
	    double *pos_z,
	    double *vel_x, // outputs: velocities in world frame
	    double *vel_y,
	    double *vel_z,
	    int reset);


/* This function returns the acceleration corrected for gravity,
   in the global reference frame, when fed with acceleration
   measures in the controller frame and camera points.
   Returns 0 on success, and -1 if calibration is needed.
*/
int correct_acc(double acc_x, // raw acceleration data for
		double acc_y, // x, y, and z, corrected to 
		double acc_z, // m/s^2, but not for gravity
		
		int ir_x1, // The x and y positions for  
		int ir_y1, // IR marker 1 and 2. These should
		int ir_x2, // be in raw pixel values.
		int ir_y2,

		double *corrected_acc_x, // corrected outputs
		double *corrected_acc_y, 
		double *corrected_acc_z,
		
		double *pan_out,
		double *tilt_out,
		double *yaw_out);

/* This function returns the acceleration corrected for gravity,
   in the global reference frame, when fed with acceleration
   measures in the controller frame.
   Returns 0 on success, and -1 if calibration is needed.
*/
int correct_acc_nocam(double acc_x, // raw acceleration data for
		      double acc_y, // x, y, and z, corrected to 
		      double acc_z, // m/s^2, but not for gravity
		
		      double *corrected_acc_x, // corrected outputs
		      double *corrected_acc_y, 
		      double *corrected_acc_z,
		
		      double pan_in,
		      double tilt_in,
		      double yaw_in,

		      double *pan_out,
		      double *tilt_out,
		      double *yaw_out);


/* This function calibrates the ir camera to the accelerometers,
   returns 0 on calibration success. Should be called repeatedly
   until it succeeds. Returns positive number of remaining iterations
   intill it is calibrated, or negative number to indicate useless
   input data.
*/
int calibrate(double acc_x, // raw acceleration data for
	      double acc_y, // x, y, and z, corrected to 
	      double acc_z, // m/s^2, but not for gravity

	      int ir_x1, // The x and y positions for  
	      int ir_y1, // IR marker 1 and 2. These should
	      int ir_x2, // be in raw pixel values.
	      int ir_y2);


int Kalman_filter(double pan_in,
		  double tilt_in,
		  double yaw_in,
		  double *pan_out,
		  double *tilt_out,
		  double *yaw_out,
		  double R);

#endif
