/*
 * Decompiled with CFR 0.152.
 */
package hockey;

import hockey.Settings;
import hockey.Util;
import hockey.api.ITeam;
import hockey.display.Intermission;
import hockey.display.Panel;
import hockey.model.Control;
import hockey.model.Game;
import hockey.model.GameChangeListener;
import hockey.model.PlayerSetup;
import hockey.model.Replay;
import hockey.model.Simulation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;

public class Arena
implements GameChangeListener {
    private Game game;
    private Simulation simulation;
    private Replay replay;
    private Panel panel;
    private PlayerSetup players;
    private Control control;
    File logFile;
    FileOutputStream out = null;
    ObjectOutputStream op = null;
    FileInputStream in = null;
    ObjectInputStream ip = null;

    public Arena() {
        if (Settings.getGUI()) {
            this.panel = new Panel(null);
        }
    }

    public void initGame(File file) {
        this.logFile = file;
        this.game = new Game();
        this.panel.reloadDecor();
        this.panel.setGame(this.game);
        this.panel.removeIntermission();
        this.simulation = new Simulation(this.game);
        this.replay = new Replay(this.game, this);
        this.simulation.setReplay(this.replay);
    }

    public Game getGame() {
        return this.game;
    }

    public Panel getPanel() {
        return this.panel;
    }

    public void startGame(ITeam iTeam, ITeam iTeam2) throws IOException, FileNotFoundException {
        if (this.logFile == null || !Settings.getLogPlay()) {
            this.players = new PlayerSetup(this.game, iTeam, iTeam2);
            this.control = new Control(this.game, this.players);
            this.control.setNotifier(this.simulation);
            if (this.logFile != null) {
                this.out = new FileOutputStream(this.logFile);
                this.op = new ObjectOutputStream(this.out);
                System.out.println("logging");
            }
            if (this.replay != null) {
                this.replay.setOutput(this.op);
            }
        } else if (this.replay != null) {
            this.in = new FileInputStream(this.logFile);
            this.ip = new ObjectInputStream(this.in);
            this.replay.setInput(this.ip);
            this.replay.restoreMode();
            System.out.println("replaying");
        }
        this.panel.setPlayerNames();
        System.out.println(this.game.getTeamA().getTeamName() + " - " + this.game.getTeamB().getTeamName());
        if (!Settings.getLogPlay()) {
            if (this.players.teamATimedOut()) {
                System.out.println(this.game.getTeamA().getTeamName() + " initiation phase timed out!");
                this.game.score(true);
                this.game.score(true);
            }
            if (this.players.teamBTimedOut()) {
                System.out.println(this.game.getTeamB().getTeamName() + " initiation phase timed out!");
                this.game.score(false);
                this.game.score(false);
            }
        }
        if (!Settings.getLogPlay() && (this.players.teamATimedOut() || this.players.teamBTimedOut())) {
            this.game.finish();
        } else {
            new Thread((Runnable)this.simulation, "Simulation").start();
            if (this.control != null) {
                new Thread((Runnable)this.control, "Control").start();
            }
        }
        this.panel.repaint();
    }

    public void awaitGame() {
        if (!this.game.isFinished()) {
            if (this.ip != null) {
                Util.await(this.replay);
            } else {
                Util.await(this.game);
            }
        }
    }

    public void finishGame() throws IOException {
        if (this.op != null) {
            this.replay.setOutput(null);
            Util.sleep(1000L);
        }
        if (this.logFile != null) {
            if (this.op != null) {
                this.op.flush();
            }
            if (this.out != null) {
                this.out.close();
            }
            if (this.in != null) {
                this.in.close();
            }
        }
        if (this.simulation != null) {
            this.simulation.stop();
        }
        if (this.control != null) {
            this.control.stop();
        }
    }

    public void setIntermission(Intermission intermission) {
        this.panel.setIntermission(intermission);
    }

    public void setGame(Game game) {
        this.simulation.setGame(game);
        if (Settings.getGUI()) {
            this.panel.setGame(game);
        }
    }

    public void reportStats(PrintStream printStream) {
        printStream.println(this.players.getTeamA().getClass().getName());
        printStream.println(this.players.getTeamB().getClass().getName());
        this.game.reportStats(printStream);
    }
}

