/*
 * Decompiled with CFR 0.152.
 */
package hockey.api;

import hockey.api.IGoalKeeper;
import hockey.api.IObject;
import hockey.api.IPlayer;
import hockey.api.IPlayerControl;
import hockey.api.IPuck;
import hockey.api.Util;
import java.awt.Color;

public abstract class Player
implements IPlayer,
IPlayerControl {
    private IPlayer impl;
    private IPlayerControl ctrl;

    public final void setPlayerControl(IPlayer iPlayer, IPlayerControl iPlayerControl) {
        this.impl = iPlayer;
        this.ctrl = iPlayerControl;
        this.init();
    }

    public abstract int getNumber();

    public abstract String getName();

    public abstract boolean isLeftHanded();

    public void init() {
    }

    public void faceOff() {
    }

    public void penaltyShot() {
    }

    public abstract void step() throws Exception;

    public int getX() {
        return this.impl.getX();
    }

    public int getY() {
        return this.impl.getY();
    }

    public int getHeading() {
        return this.impl.getHeading();
    }

    public int getSpeed() {
        return this.impl.getSpeed();
    }

    public int getStickAngle() {
        return this.impl.getStickAngle();
    }

    public int getStickR() {
        return this.impl.getStickR();
    }

    public int getStickX() {
        return this.impl.getStickX();
    }

    public int getStickY() {
        return this.impl.getStickY();
    }

    public IObject getStick() {
        return this.impl.getStick();
    }

    public boolean isOpponent() {
        return this.impl.isOpponent();
    }

    public boolean hasPuck() {
        return this.impl.hasPuck();
    }

    public int getIndex() {
        return this.impl.getIndex();
    }

    public boolean getAimOnStick() {
        return this.ctrl.getAimOnStick();
    }

    public int getTargetSpeed() {
        return this.ctrl.getTargetSpeed();
    }

    public int getTargetHeading() {
        return this.ctrl.getTargetHeading();
    }

    public int getTurnSpeed() {
        return this.ctrl.getTurnSpeed();
    }

    public int getTargetStickAngle() {
        return this.ctrl.getTargetStickAngle();
    }

    public int getTargetStickR() {
        return this.ctrl.getTargetStickR();
    }

    public void setAimOnStick(boolean bl) {
        this.ctrl.setAimOnStick(bl);
    }

    public void skate(int n) {
        this.ctrl.skate(n);
    }

    public void skate(int n, int n2, int n3) {
        this.skate(n3);
        this.turn(n, n2, 180);
        if (n3 < 0) {
            this.turn(this.getTargetHeading() + 180, 180);
        }
    }

    public void skate(IObject iObject, int n) {
        this.skate(n);
        if (this.getAimOnStick()) {
            this.turn(Util.collisionHeading(iObject, this.getStick(), n), 180);
        } else {
            this.turn(Util.collisionHeading(iObject, this, n), 180);
        }
        if (n < 0) {
            this.turn(this.getTargetHeading() + 180, 180);
        }
    }

    public void turn(int n, int n2) {
        this.ctrl.turn(n, n2);
    }

    public void turn(int n, int n2, int n3) {
        if (this.getAimOnStick()) {
            this.turn((int)Util.datan2(n2 - this.getStickY(), n - this.getStickX()), n3);
        } else {
            this.turn((int)Util.datan2(n2 - this.getY(), n - this.getX()), n3);
        }
    }

    public void turn(IObject iObject, int n) {
        this.turn(iObject.getX(), iObject.getY(), n);
    }

    public void moveStick(int n, int n2) {
        this.ctrl.moveStick(n, n2);
    }

    public void shoot(int n, int n2) {
        this.ctrl.shoot(n, n2);
    }

    public void shoot(int n, int n2, int n3) {
        this.shoot((int)Util.datan2(n2 - this.getStickY(), n - this.getStickX()), n3);
    }

    public void shoot(IObject iObject, int n) {
        this.shoot(Util.collisionHeading(iObject, this.getStick(), n), n);
    }

    public int getScore(boolean bl) {
        return this.ctrl.getScore(bl);
    }

    public IPuck getPuck() {
        return this.ctrl.getPuck();
    }

    public IGoalKeeper getGoalKeeper(int n) {
        return this.ctrl.getGoalKeeper(n);
    }

    public IPlayer getPlayer(int n) {
        return this.ctrl.getPlayer(n);
    }

    public void setMessage(String string) {
        this.ctrl.setMessage(string);
    }

    public void setDebugPoint(int n, int n2, Color color) {
        this.ctrl.setDebugPoint(n, n2, color);
    }

    public void showDebugPoint(boolean bl) {
        this.ctrl.showDebugPoint(bl);
    }
}

