/*
 * Decompiled with CFR 0.152.
 */
package hockey.api;

import hockey.api.IObject;

public class Util {
    public static int sqr(int n) {
        return n * n;
    }

    public static double sqr(double d) {
        return d * d;
    }

    public static double dist(double d, double d2) {
        return Math.sqrt(d * d + d2 * d2);
    }

    public static double dist(IObject iObject, IObject iObject2) {
        return Util.dist(iObject.getX() - iObject2.getX(), iObject.getY() - iObject2.getY());
    }

    public static double dist2(double d, double d2) {
        return d * d + d2 * d2;
    }

    public static int dist2(int n, int n2) {
        return n * n + n2 * n2;
    }

    public static int dist2(IObject iObject, IObject iObject2) {
        return Util.dist2(iObject.getX() - iObject2.getX(), iObject.getY() - iObject2.getY());
    }

    public static double dangle(double d, double d2) {
        return Math.IEEEremainder(d - d2, 360.0);
    }

    public static double rad(double d) {
        return Math.toRadians(d);
    }

    public static double deg(double d) {
        return Math.toDegrees(d);
    }

    public static double cosd(double d) {
        return Math.cos(Util.rad(d));
    }

    public static double sind(double d) {
        return Math.sin(Util.rad(d));
    }

    public static double tand(double d) {
        return Math.tan(Util.rad(d));
    }

    public static double datan2(double d, double d2) {
        return Util.deg(Math.atan2(d, d2));
    }

    public static double datan2(IObject iObject, IObject iObject2) {
        return Util.deg(Math.atan2(iObject.getY() - iObject2.getY(), iObject.getX() - iObject2.getX()));
    }

    public static int clamp(int n, int n2, int n3) {
        return Math.min(Math.max(n, n2), n3);
    }

    public static int clampPos(int n, int n2) {
        return Util.clamp(0, n, n2);
    }

    public static int clampAbs(int n, int n2) {
        return Util.clamp(-n2, n, n2);
    }

    public static double clamp(double d, double d2, double d3) {
        return Math.min(Math.max(d, d2), d3);
    }

    public static double clampPos(double d, double d2) {
        return Util.clamp(0.0, d, d2);
    }

    public static double clampAbs(double d, double d2) {
        return Util.clamp(-d2, d, d2);
    }

    public static double solve(double d, double d2, double d3, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = Math.abs(d) < 1.0E-30;
        if (bl && bl2 && Math.abs(d2) > 1.0E-13) {
            return -d3 / 2.0 / d2;
        }
        double d4 = d2 * d2 - d * d3;
        if (bl2 || d4 < 0.0) {
            return Double.NaN;
        }
        return (-d2 + (double)(bl ? 1 : -1) * Math.sqrt(d4)) / d;
    }

    private static double solvePos(double d, double d2, double d3) {
        boolean bl;
        boolean bl2 = bl = Math.abs(d) < 1.0E-30;
        if (bl && Math.abs(d2) > 1.0E-13) {
            return -d3 / 2.0 / d2;
        }
        double d4 = d2 * d2 - d * d3;
        if (bl || d4 < 0.0) {
            return Double.NaN;
        }
        double d5 = Math.sqrt(d4);
        double d6 = (-d2 - d5) / d;
        double d7 = (-d2 + d5) / d;
        return d6 < 0.0 || d7 < 0.0 ? Math.max(d6, d7) : Math.min(d6, d7);
    }

    private static double collisionTime(IObject iObject, IObject iObject2, int n) {
        int n2 = iObject.getX() - iObject2.getX();
        int n3 = iObject.getY() - iObject2.getY();
        double d = (double)iObject.getSpeed() * Util.cosd(iObject.getHeading());
        double d2 = (double)iObject.getSpeed() * Util.sind(iObject.getHeading());
        return Util.solve(d * d + d2 * d2 - (double)(n * n), (double)n2 * d + (double)n3 * d2, n2 * n2 + n3 * n3, true);
    }

    public static int collisionHeading(IObject iObject, IObject iObject2, int n) {
        double d;
        int n2 = iObject.getX() - iObject2.getX();
        int n3 = iObject.getY() - iObject2.getY();
        double d2 = (double)iObject.getSpeed() * Util.cosd(iObject.getHeading());
        double d3 = Util.solvePos(d2 * d2 + (d = (double)iObject.getSpeed() * Util.sind(iObject.getHeading())) * d - (double)(n * n), (double)n2 * d2 + (double)n3 * d, n2 * n2 + n3 * n3);
        if (d3 != d3 || d3 < 0.001) {
            if (iObject.getSpeed() == 0) {
                return (int)Util.datan2(iObject, iObject2);
            }
            return iObject.getHeading();
        }
        double d4 = (double)n2 + d2 * d3;
        double d5 = (double)n3 + d * d3;
        return (int)Util.datan2(d5, d4);
    }
}

