/*
 * Decompiled with CFR 0.152.
 */
package hockey.display;

import hockey.Settings;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Frame
extends JFrame {
    GraphicsDevice dev;
    DisplayMode originalMode;

    public Frame(String string, JPanel jPanel) {
        super(string);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (Frame.this.originalMode != null) {
                    Frame.this.dev.setDisplayMode(Frame.this.originalMode);
                } else if (Frame.this.dev != null && Frame.this.dev.isFullScreenSupported()) {
                    Frame.this.dev.setFullScreenWindow(null);
                }
                System.exit(0);
            }
        });
        this.getContentPane().add(jPanel);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.dev = graphicsEnvironment.getDefaultScreenDevice();
        if (Settings.getFullScreen() && this.dev.isFullScreenSupported()) {
            System.err.println("Fullscreen!");
            this.setUndecorated(true);
            this.setResizable(false);
            this.originalMode = this.dev.getDisplayMode();
            this.dev.setFullScreenWindow(this);
            this.dev.setDisplayMode(this.findDisplayMode(800, 600, 32, 85));
            this.validate();
        } else {
            this.pack();
            this.setVisible(true);
        }
    }

    private DisplayMode findDisplayMode(int n, int n2, int n3, int n4) {
        DisplayMode[] displayModeArray = this.dev.getDisplayModes();
        int n5 = -1;
        int n6 = 0;
        while (n6 < displayModeArray.length) {
            if (displayModeArray[n6].getWidth() == n && displayModeArray[n6].getHeight() == n2 && displayModeArray[n6].getBitDepth() == 16 && (n5 == -1 || displayModeArray[n6].getRefreshRate() > displayModeArray[n5].getRefreshRate())) {
                n5 = n6;
            }
            ++n6;
        }
        System.err.println("Best: " + n5);
        return displayModeArray[n5];
    }

    class Hook
    extends Thread {
        Hook() {
        }

        public void run() {
            Frame.this.dev.setDisplayMode(Frame.this.originalMode);
            if (Frame.this.dev != null && Frame.this.dev.isFullScreenSupported()) {
                Frame.this.dev.setFullScreenWindow(null);
            }
        }
    }
}

