/*
 * Decompiled with CFR 0.152.
 */
package hockey.display;

import hockey.display.Decor;
import hockey.model.Game;
import hockey.model.Puck;
import java.awt.Graphics2D;

public class View {
    Game game;
    Decor decor;
    double scaleFactor = 2.0;

    public View(Game game) {
        this.game = game;
        this.decor = new Decor();
        this.decor.load();
    }

    public void reloadDecor() {
        this.decor.load();
    }

    public void setGame(Game game) {
        this.game = game;
    }

    public void paint(Graphics2D graphics2D, double d) {
        boolean bl = false;
        if (this.game != null) {
            boolean bl2 = bl = this.game.getPeriod() % 2 == 0 && this.game.getPeriod() > 0;
        }
        if (bl) {
            graphics2D.rotate(Math.PI);
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (this.game != null) {
            Puck puck = this.game.getPuck();
            d2 = puck.getX();
            d3 = puck.getY();
            d4 = Math.abs(puck.getSpeed());
        }
        this.scaleFactor = (100.0 * this.scaleFactor + 2.0) / 101.0;
        if (this.game != null && this.game.isReplay()) {
            this.scaleFactor = this.game.getReplayScaleFactor();
        }
        double d5 = 1.0;
        double d6 = 1.0;
        if (this.scaleFactor > 1.01) {
            double d7;
            d5 = d7 = 0.7 + 0.3 / this.scaleFactor;
            d6 = d7;
            d6 = this.scaleFactor > d ? d * (0.7 + 0.3 * d / this.scaleFactor) : this.scaleFactor;
            graphics2D.translate(d2 * d5, d3 * d6);
            graphics2D.scale(this.scaleFactor, this.scaleFactor);
            graphics2D.translate(-d2, -d3);
        } else {
            graphics2D.scale(this.scaleFactor, this.scaleFactor);
        }
        if (bl) {
            graphics2D.rotate(Math.PI);
        }
        Game.paintRink(graphics2D);
        this.decor.paint(graphics2D);
        Game.drawMarkings(graphics2D);
        if (bl) {
            graphics2D.rotate(Math.PI);
        }
        if (this.game != null) {
            this.game.paint(graphics2D);
        }
        if (this.scaleFactor > 1.01) {
            graphics2D.translate(d2, d3);
            graphics2D.scale(1.0 / this.scaleFactor, 1.0 / this.scaleFactor);
            graphics2D.translate(-d2 * d5, -d3 * d6);
        } else {
            graphics2D.scale(1.0 / this.scaleFactor, 1.0 / this.scaleFactor);
        }
        if (bl) {
            graphics2D.rotate(Math.PI);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void faceOff(double d, double d2) {
        Game game = this.game;
        synchronized (game) {
            if (this.game.getPeriod() % 2 == 0) {
                d *= -1.0;
                d2 *= -1.0;
            }
            Puck puck = this.game.getPuck();
            this.game.faceOff((d - puck.getX() * 0.7) / this.scaleFactor + puck.getX(), (d2 - puck.getY() * 0.7) / this.scaleFactor + puck.getY());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test(double d, double d2) {
        Game game = this.game;
        synchronized (game) {
            if (this.game.getPeriod() % 2 == 0) {
                d *= -1.0;
                d2 *= -1.0;
            }
            Puck puck = this.game.getPuck();
            this.game.test((d - puck.getX() * 0.7) / this.scaleFactor + puck.getX(), (d2 - puck.getY() * 0.7) / this.scaleFactor + puck.getY());
        }
    }
}

