/*
 * Decompiled with CFR 0.152.
 */
package hockey.ide;

import hockey.Arena;
import hockey.Settings;
import hockey.Util;
import hockey.display.Frame;
import hockey.ide.DMZGamePanel;
import hockey.ide.DMZTeamList;
import hockey.ide.DebugPanel;
import hockey.tournament.PlayFinals;
import hockey.tournament.PlayGroups;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class DMZ
extends JPanel {
    private Arena arena;
    private DMZTeamList home;
    private DMZTeamList away;

    public DMZ(Arena arena) {
        this.setLayout(new BorderLayout());
        this.arena = arena;
        this.home = new DMZTeamList(" Hemmalag", "teamlist");
        this.away = new DMZTeamList(" Bortalag", "teamlist");
        Box box = Box.createVerticalBox();
        box.add(new DMZGamePanel(arena, this.home, this.away));
        box.add(new JSeparator());
        box.add(new DebugPanel(arena));
        this.add((Component)box, "Center");
        Box box2 = Box.createHorizontalBox();
        box2.add(this.home);
        box2.add(new JSeparator(1));
        Box box3 = Box.createHorizontalBox();
        box3.add(new JSeparator(1));
        box3.add(this.away);
        this.add((Component)box2, "West");
        this.add((Component)box3, "East");
        new Repaint().start();
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println("Copyright (c) 2003 Per Austrin, Fredrik Niemel\u00e4, Mattias de Zalenski.");
        Settings.setHockeyPath(".");
        if (stringArray.length > 1 && stringArray[0].equals("-gruppspel")) {
            PlayGroups.main(stringArray);
        } else if (stringArray.length > 1 && stringArray[0].equals("-finalspel")) {
            PlayFinals.main(stringArray);
        } else if (stringArray.length > 0) {
            System.err.println("usage:  java -jar hockey.jar [[-gruppspel grupp ...] | [-finalspel laglista]]");
        } else {
            Settings.setIDE(true);
            Arena arena = new Arena();
            Frame frame = new Frame("Ishockey!", new DMZ(arena));
        }
    }

    private class Repaint
    extends Thread {
        private Repaint() {
        }

        public void run() {
            while (true) {
                Util.sleep(300L);
                DMZ.this.repaint();
            }
        }
    }
}

