/*
 * Decompiled with CFR 0.152.
 */
package hockey.ide;

import hockey.Arena;
import hockey.Loader;
import hockey.Settings;
import hockey.display.Slider;
import hockey.ide.DMZTeamList;
import hockey.model.Game;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DMZGamePanel
extends JPanel {
    private Arena arena;
    private DMZTeamList home;
    private DMZTeamList away;

    public DMZGamePanel(Arena arena, DMZTeamList dMZTeamList, DMZTeamList dMZTeamList2) {
        this.arena = arena;
        this.home = dMZTeamList;
        this.away = dMZTeamList2;
        this.setLayout(new BorderLayout());
        Slider slider = new Slider();
        Box box = Box.createVerticalBox();
        Box box2 = Box.createHorizontalBox();
        box2.add(slider);
        box2.add(new JLabel("Zoom "));
        box.add(box2);
        box.add(this.optionsBox());
        this.add((Component)arena.getPanel(), "Center");
        this.add((Component)box, "South");
        arena.getPanel().setSlider(slider);
    }

    private void startGame() {
        String string = this.home.getSelectedTeam();
        String string2 = this.away.getSelectedTeam();
        if (string != null && string2 != null) {
            try {
                this.arena.finishGame();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            this.arena.initGame(null);
            try {
                this.arena.startGame(Loader.loadTeam(string, true), Loader.loadTeam(string2, true));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private Box optionsBox() {
        Box box = Box.createVerticalBox();
        Box box2 = Box.createHorizontalBox();
        OptionsListener optionsListener = new OptionsListener();
        JCheckBox jCheckBox = new JCheckBox("Visa modell");
        jCheckBox.addItemListener(optionsListener);
        box2.add(jCheckBox);
        JCheckBox jCheckBox2 = new JCheckBox("Visa spelare");
        jCheckBox2.addItemListener(optionsListener);
        box2.add(jCheckBox2);
        JCheckBox jCheckBox3 = new JCheckBox("Visa testpunkter");
        jCheckBox3.addItemListener(optionsListener);
        box2.add(jCheckBox3);
        JCheckBox jCheckBox4 = new JCheckBox("Markera puck");
        jCheckBox4.addItemListener(optionsListener);
        box2.add(jCheckBox4);
        optionsListener.setCheckBoxes(jCheckBox, jCheckBox2, jCheckBox3, jCheckBox4);
        optionsListener.checkSettings();
        Box box3 = Box.createHorizontalBox();
        JButton jButton = new JButton("Spela");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Settings.setPenalty(false);
                DMZGamePanel.this.startGame();
            }
        });
        box3.add(jButton);
        JButton jButton2 = new JButton("Straffar");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Settings.setPenalty(true);
                DMZGamePanel.this.startGame();
            }
        });
        box3.add(jButton2);
        JButton jButton3 = new JButton("Teka");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Game game = DMZGamePanel.this.arena.getGame();
                if (game != null) {
                    game.stop(8);
                }
            }
        });
        box3.add(jButton3);
        JButton jButton4 = new JButton("Stopp");
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DMZGamePanel.this.arena.finishGame();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        box3.add(jButton4);
        box.add(box2);
        box.add(box3);
        return box;
    }

    private class OptionsListener
    implements ItemListener {
        private JCheckBox sm;
        private JCheckBox sp;
        private JCheckBox sdp;
        private JCheckBox mp;
        private JCheckBox pp;

        private OptionsListener() {
        }

        public void setCheckBoxes(JCheckBox jCheckBox, JCheckBox jCheckBox2, JCheckBox jCheckBox3, JCheckBox jCheckBox4) {
            this.sm = jCheckBox;
            this.sp = jCheckBox2;
            this.sdp = jCheckBox3;
            this.mp = jCheckBox4;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            if (itemSelectable == this.sm) {
                Settings.setTechnical(itemEvent.getStateChange() == 1);
            } else if (itemSelectable == this.sp) {
                Settings.setReal(itemEvent.getStateChange() == 1);
            } else if (itemSelectable == this.sdp) {
                Settings.setPlayerDebug(itemEvent.getStateChange() == 1);
            } else if (itemSelectable == this.mp) {
                Settings.setMarkPuck(itemEvent.getStateChange() == 1);
            }
            this.checkSettings();
        }

        public void checkSettings() {
            this.sm.setSelected(Settings.getTechnical());
            this.sp.setSelected(Settings.getReal());
            this.sdp.setSelected(Settings.getPlayerDebug());
            this.mp.setSelected(Settings.getMarkPuck());
        }
    }
}

