/*
 * Decompiled with CFR 0.152.
 */
package hockey.ide;

import hockey.Arena;
import hockey.Settings;
import hockey.display.Slider;
import hockey.model.Game;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GamePanel
extends JPanel {
    private Arena arena;

    public GamePanel(Arena arena) {
        this.arena = arena;
        this.setLayout(new BorderLayout());
        Slider slider = new Slider();
        Box box = Box.createVerticalBox();
        Box box2 = Box.createHorizontalBox();
        box2.add(slider);
        box2.add(new JLabel("Zoom "));
        box.add(box2);
        box.add(this.optionsBox());
        this.add((Component)arena.getPanel(), "Center");
        this.add((Component)box, "South");
        arena.getPanel().setSlider(slider);
    }

    private Box optionsBox() {
        Box box = Box.createHorizontalBox();
        OptionsListener optionsListener = new OptionsListener();
        JCheckBox jCheckBox = new JCheckBox("Visa modell");
        jCheckBox.addItemListener(optionsListener);
        box.add(jCheckBox);
        JCheckBox jCheckBox2 = new JCheckBox("Visa spelare");
        jCheckBox2.addItemListener(optionsListener);
        box.add(jCheckBox2);
        JCheckBox jCheckBox3 = new JCheckBox("Visa testpunkter");
        jCheckBox3.addItemListener(optionsListener);
        box.add(jCheckBox3);
        JCheckBox jCheckBox4 = new JCheckBox("Markera puck");
        jCheckBox4.addItemListener(optionsListener);
        box.add(jCheckBox4);
        JCheckBox jCheckBox5 = new JCheckBox("Straffar");
        jCheckBox5.addItemListener(optionsListener);
        box.add(jCheckBox5);
        optionsListener.setCheckBoxes(jCheckBox, jCheckBox2, jCheckBox3, jCheckBox4, jCheckBox5);
        optionsListener.checkSettings();
        box.add(Box.createGlue());
        JButton jButton = new JButton("Teka");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Game game = GamePanel.this.arena.getGame();
                if (game != null) {
                    game.stop(8);
                }
            }
        });
        box.add(jButton);
        JButton jButton2 = new JButton("Stopp");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    GamePanel.this.arena.finishGame();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        box.add(jButton2);
        return box;
    }

    private class OptionsListener
    implements ItemListener {
        private JCheckBox sm;
        private JCheckBox sp;
        private JCheckBox sdp;
        private JCheckBox mp;
        private JCheckBox pp;

        private OptionsListener() {
        }

        public void setCheckBoxes(JCheckBox jCheckBox, JCheckBox jCheckBox2, JCheckBox jCheckBox3, JCheckBox jCheckBox4, JCheckBox jCheckBox5) {
            this.sm = jCheckBox;
            this.sp = jCheckBox2;
            this.sdp = jCheckBox3;
            this.mp = jCheckBox4;
            this.pp = jCheckBox5;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            if (itemSelectable == this.sm) {
                Settings.setTechnical(itemEvent.getStateChange() == 1);
            } else if (itemSelectable == this.sp) {
                Settings.setReal(itemEvent.getStateChange() == 1);
            } else if (itemSelectable == this.sdp) {
                Settings.setPlayerDebug(itemEvent.getStateChange() == 1);
            } else if (itemSelectable == this.mp) {
                Settings.setMarkPuck(itemEvent.getStateChange() == 1);
            } else if (itemSelectable == this.pp) {
                Settings.setPenalty(itemEvent.getStateChange() == 1);
            }
            this.checkSettings();
        }

        public void checkSettings() {
            this.sm.setSelected(Settings.getTechnical());
            this.sp.setSelected(Settings.getReal());
            this.sdp.setSelected(Settings.getPlayerDebug());
            this.mp.setSelected(Settings.getMarkPuck());
        }
    }
}

