/*
 * Decompiled with CFR 0.152.
 */
package hockey.ide;

import hockey.Arena;
import hockey.Loader;
import hockey.Settings;
import hockey.Util;
import hockey.display.Frame;
import hockey.ide.Controls;
import hockey.ide.DebugPanel;
import hockey.ide.GameAction;
import hockey.ide.GamePanel;
import hockey.ide.StatusRow;
import hockey.ide.TeamList;
import hockey.ide.TeamListPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class IDE
extends JPanel {
    private Arena arena;
    private static StatusRow status;

    public IDE(String string, Arena arena) {
        this.setLayout(new BorderLayout());
        this.arena = arena;
        status = new StatusRow();
        TeamListPanel teamListPanel = new TeamListPanel(arena, status);
        Controls controls = new Controls(string, teamListPanel, status);
        TeamList[] teamListArray = teamListPanel.getTeamLists();
        int n = 0;
        while (n < 2) {
            teamListArray[n].addActionListener(new GameAction(arena, teamListArray[n], controls, n != 0));
            ++n;
        }
        Box box = Box.createVerticalBox();
        box.add(new GamePanel(arena));
        box.add(new JSeparator());
        box.add(new DebugPanel(arena));
        this.add((Component)box, "Center");
        Box box2 = Box.createHorizontalBox();
        box2.add(new JSeparator(1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)teamListPanel, "Center");
        jPanel.add((Component)controls, "South");
        box2.add(jPanel);
        this.add((Component)box2, "East");
        this.add((Component)status, "South");
        new Repaint().start();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length > 1 && stringArray[0].equals("-loadonly")) {
            Loader.test(stringArray[1]);
            return;
        }
        Settings.setIDE(true);
        String string = stringArray.length < 1 ? "ghost" : "team" + stringArray[0];
        Arena arena = new Arena();
        Frame frame = new Frame("Ishockey!", new IDE(string, arena));
    }

    public static StatusRow getStatus() {
        return status;
    }

    private class Repaint
    extends Thread {
        int count = 0;

        private Repaint() {
        }

        public void run() {
            while (true) {
                Util.sleep(300L);
                IDE.this.repaint();
                if (this.count % 30 == 0) {
                    status.updateMessages();
                }
                ++this.count;
            }
        }
    }
}

