/*
 * Decompiled with CFR 0.152.
 */
package hockey.ide;

import hockey.Loader;
import hockey.Util;
import hockey.api.ITeam;
import hockey.ide.IDE;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TeamList
extends JPanel {
    private Vector types;
    private DefaultListModel model;
    private JCheckBox opt;
    private JLabel classLabel;
    private JLabel nameLabel;
    private JLabel timeLabel;
    private JList list;
    private File listFile;
    private String localTeam;
    private boolean global;
    private ActionListener actionListener;
    private boolean failedSubmitAcc = true;

    public TeamList(String string, String string2, String string3, boolean bl) {
        super(new BorderLayout());
        this.listFile = new File(string3);
        this.types = new Vector();
        this.model = new DefaultListModel();
        this.global = bl;
        JLabel jLabel = new JLabel(string);
        this.add((Component)jLabel, "North");
        this.list = new JList(this.model);
        this.list.setPrototypeCellValue("Mmmmmmmmmmm......");
        JScrollPane jScrollPane = new JScrollPane(this.list);
        this.add((Component)jScrollPane, "Center");
        JPanel jPanel = new JPanel(new BorderLayout());
        Box box = Box.createVerticalBox();
        this.classLabel = new JLabel(" ");
        this.nameLabel = new JLabel(" ");
        this.timeLabel = new JLabel(" ");
        box.add(this.nameLabel);
        box.add(this.classLabel);
        box.add(this.timeLabel);
        jPanel.add((Component)box, "West");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JButton jButton = new JButton(string2);
        this.opt = new JCheckBox(bl ? "Skicka in f\u00f6re match" : "Kompilera f\u00f6re match");
        jPanel2.add((Component)jButton, "North");
        jPanel2.add((Component)this.opt, "South");
        jPanel.add((Component)jPanel2, "South");
        this.add((Component)jPanel, "South");
        this.setLocalTeam(null);
        this.updateList();
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && TeamList.this.actionListener != null) {
                    TeamList.this.actionListener.actionPerformed(new ActionEvent(TeamList.this, 1001, ""));
                }
            }
        });
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TeamList.this.actionListener != null) {
                    TeamList.this.actionListener.actionPerformed(new ActionEvent(TeamList.this, 1001, ""));
                }
            }
        });
    }

    public boolean getPreCompile() {
        return this.opt.isSelected();
    }

    public String getLocalTeam() {
        return this.localTeam;
    }

    public boolean setLocalTeam(String string) {
        if (string != null) {
            try {
                ITeam iTeam = Loader.loadTeam(string, this.global);
                this.setLocalTeamName(string, iTeam.getTeamName(), System.currentTimeMillis());
            }
            catch (Exception exception) {
                IDE.getStatus().setError("Kunde inte ladda lag: " + exception.getMessage());
                return false;
            }
        } else {
            this.setLocalTeamName(null, null, System.currentTimeMillis());
        }
        return true;
    }

    public void setLocalTeamName(String string, String string2, long l) {
        if (string != null) {
            this.nameLabel.setText(string2);
            this.classLabel.setForeground(Color.BLACK);
            this.classLabel.setText(string);
            this.timeLabel.setText(Util.timeString(l));
        } else {
            this.nameLabel.setText(" ");
            this.classLabel.setForeground(Color.RED);
            this.classLabel.setText(this.global ? "<ej inskickat>" : "<ej kompilerat>");
            this.timeLabel.setText(" ");
        }
        this.localTeam = string;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this.actionListener == actionListener) {
            this.actionListener = null;
        }
    }

    public String getSelectedTeam() {
        int n = this.list.getSelectedIndex();
        if (n >= 0) {
            return (String)this.types.get(n);
        }
        return null;
    }

    public synchronized boolean updateList() {
        boolean bl = true;
        try {
            FileReader fileReader = new FileReader(this.listFile);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            int n = this.list.getSelectedIndex();
            this.types.clear();
            this.model.clear();
            while (true) {
                String string = bufferedReader.readLine();
                String string2 = bufferedReader.readLine();
                String string3 = bufferedReader.readLine();
                if (string == null || string2 == null) break;
                this.types.addElement(string);
                this.model.addElement(string2);
            }
            fileReader.close();
            this.list.setSelectedIndex(n);
            if (this.global) {
                bl &= this.updateSubmit();
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return bl;
    }

    public void clearFailedSubmit() {
        this.failedSubmitAcc = false;
    }

    public boolean updateSubmit() throws IOException {
        try {
            FileReader fileReader = new FileReader(".hockey/status");
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string = bufferedReader.readLine();
            fileReader.close();
            if ("ok".equals(string)) {
                File file = new File(".hockey/submitted");
                fileReader = new FileReader(file);
                bufferedReader = new BufferedReader(fileReader);
                String string2 = bufferedReader.readLine();
                String string3 = bufferedReader.readLine();
                long l = file.lastModified();
                fileReader.close();
                this.setLocalTeamName(string2, string3, l);
            } else {
                if ("pending".equals(string)) {
                    return true;
                }
                if (!this.failedSubmitAcc) {
                    this.failedSubmitAcc = true;
                    IDE.getStatus().setError("Misslyckades med att skicka in!");
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return true;
        }
        return true;
    }
}

