/*
 * Decompiled with CFR 0.152.
 */
package hockey.model;

import hockey.Util;
import hockey.model.Game;
import hockey.model.PlayerSetup;
import hockey.model.Simulation;

public class Control
implements Runnable {
    Game game;
    Game copy;
    PlayerSetup players;
    Simulation notifier;
    Stepper[] steppers = new Stepper[12];
    long time;
    boolean finished = false;
    boolean facedOff;
    boolean penaltyShot;
    int step = 0;

    public Control(Game game, PlayerSetup playerSetup) {
        this.game = game;
        this.players = playerSetup;
        int n = 0;
        while (n < 12) {
            this.steppers[n] = new Stepper(n);
            ++n;
        }
    }

    public void setNotifier(Simulation simulation) {
        this.notifier = simulation;
    }

    public void run() {
        int n = 0;
        while (n < 12) {
            this.steppers[n].start();
            ++n;
        }
        this.time = System.currentTimeMillis();
        while (!this.finished) {
            if (this.game.isStopped() || Util.timeInaccurate(this.time, 700L)) {
                this.time = System.currentTimeMillis();
            }
            this.copy();
            this.facedOff = this.notifier.facedOff();
            this.penaltyShot = this.notifier.penaltyShot();
            this.step(true);
            Util.await(this.notifier);
        }
        int n2 = 0;
        while (n2 < 12) {
            if (this.steppers[n2].alive) {
                Util.stop(this.steppers[n2]);
            }
            ++n2;
        }
    }

    public void stop() {
        this.finished = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy() {
        try {
            Game game = this.game;
            synchronized (game) {
                this.copy = (Game)this.game.clone();
            }
            if (this.notifier != null) {
                this.notifier.setTarget(this.copy);
            }
            this.players.setGame(this.copy);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void step(boolean bl) {
        ++this.step;
        int n = 0;
        while (n < 12) {
            int n2 = n / 2 + (n % 2 == 0 ? 6 : 0);
            if (this.game.isPlayerPlaying(n2)) {
                Stepper stepper = this.steppers[n2];
                synchronized (stepper) {
                    this.steppers[n2].notifyAll();
                    if (this.steppers[n2].alive && this.steppers[n2].step < this.step - 30) {
                        Util.stop(this.steppers[n2]);
                        this.steppers[n2].alive = false;
                        System.err.println("Player " + n2 + " TIMEOUT!!!");
                        this.players.getPlayer(n2).setMessage("TIMEOUT!!!");
                    }
                }
            } else {
                this.steppers[n2].step = this.step;
            }
            this.time += 4L;
            if (bl) {
                Util.await(this.time);
            }
            ++n;
        }
        this.time += 50L;
    }

    public void stepPlayer(int n) {
        try {
            if (!this.copy.isPaused()) {
                if (this.facedOff) {
                    this.players.getPlayer(n).faceOff();
                }
                if (this.penaltyShot) {
                    this.players.getPlayer(n).penaltyShot();
                }
                this.players.getPlayer(n).step();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private class Stepper
    extends Thread {
        int index;
        int step = 0;
        boolean alive = true;

        public Stepper(int n) {
            super("Team " + (n % 2 == 0 ? (char)'A' : 'B') + "'s player " + n / 2);
            this.index = n;
        }

        public void run() {
            while (!Control.this.finished && this.alive) {
                Util.await(this);
                this.step = Control.this.step;
                Control.this.stepPlayer(this.index);
            }
            this.alive = false;
        }
    }
}

