/*
 * Decompiled with CFR 0.152.
 */
package hockey.model;

import hockey.Settings;
import hockey.model.Goal;
import hockey.model.GoalKeeper;
import hockey.model.Player;
import hockey.model.Puck;
import hockey.model.Rink;
import hockey.model.Rules;
import hockey.model.Team;
import java.awt.Graphics2D;
import java.io.PrintStream;
import java.io.Serializable;

public class Game
implements Cloneable,
Serializable {
    public static int PERIOD_LENGTH = 60;
    public static int PERIODS = 3;
    public static final int PENALTY_LENGTH = 5;
    public static final int NO_STOP = 0;
    public static final int GOAL_STOP = 1;
    public static final int PERIOD_STOP = 2;
    public static final int FINISHED = 3;
    public static final int OFFSIDE = 4;
    public static final int ICING = 5;
    public static final int BLOCKED = 6;
    public static final int INACTIVE = 7;
    public static final int FACE_OFF = 8;
    Rules rules;
    Puck puck;
    Team teamA;
    Team teamB;
    int scoreA = 0;
    int scoreB = 0;
    int[] periodScoreA;
    int[] periodScoreB;
    private int[] scoreRecord;
    int period = 0;
    int time = 0;
    boolean stopped = false;
    boolean paused = false;
    int stopReason = 0;
    int stopTime = 0;
    double resumeX = 0.0;
    double resumeY = 0.0;
    boolean finished = false;
    boolean replay = false;
    float replayScaleFactor = 2.0f;
    boolean sudden = false;
    boolean penalty = false;
    int penaltyPlayerA = 0;
    int penaltyPlayerB = 12;
    int penaltyTime = 0;
    private static Rink RINK = new Rink();
    private static Goal GOAL_A = new Goal(false);
    private static Goal GOAL_B = new Goal(true);

    public Game() {
        PERIODS = 3;
        PERIOD_LENGTH = Settings.getPeriodLength();
        if (Settings.getSinglePeriod()) {
            PERIODS = 1;
        }
        if (Settings.getNoPeriods()) {
            PERIODS = 0;
        }
        this.rules = new Rules();
        this.puck = new Puck();
        this.teamA = new Team(false);
        this.teamB = new Team(true);
        this.puck.setGame(this);
        this.periodScoreA = new int[PERIODS + 2];
        this.periodScoreB = new int[PERIODS + 2];
        this.scoreRecord = new int[0];
        int n = 0;
        while (n < PERIODS) {
            this.periodScoreB[n] = 0;
            this.periodScoreA[n] = 0;
            ++n;
        }
        this.faceOff();
        this.stop(2);
        this.paused = true;
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        Game game = (Game)super.clone();
        game.rules = (Rules)this.rules.clone();
        game.puck = (Puck)this.puck.clone();
        game.teamA = (Team)this.teamA.clone();
        game.teamB = (Team)this.teamB.clone();
        game.puck.setGame(game);
        game.periodScoreA = (int[])this.periodScoreA.clone();
        game.periodScoreB = (int[])this.periodScoreB.clone();
        game.scoreRecord = (int[])this.scoreRecord.clone();
        return game;
    }

    protected Object readResolve() {
        this.puck.setGame(this);
        return this;
    }

    public synchronized void copyTargetFrom(Game game) {
        this.teamA.copyTargetFrom(game.teamA);
        this.teamB.copyTargetFrom(game.teamB);
    }

    public Rules getRules() {
        return this.rules;
    }

    public Puck getPuck() {
        return this.puck;
    }

    public Team getTeamA() {
        return this.teamA;
    }

    public Team getTeamB() {
        return this.teamB;
    }

    public int getScoreA() {
        return this.scoreA;
    }

    public int getScoreB() {
        return this.scoreB;
    }

    public int[] getPeriodScoreA() {
        return this.periodScoreA;
    }

    public int[] getPeriodScoreB() {
        return this.periodScoreB;
    }

    public int getPeriod() {
        return this.period;
    }

    public int getTime() {
        return this.time;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public int getStopReason() {
        return this.stopReason;
    }

    public int getStopTime() {
        return this.stopTime;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isReplay() {
        return this.replay;
    }

    public float getReplayScaleFactor() {
        return this.replayScaleFactor;
    }

    public boolean isSudden() {
        return this.sudden;
    }

    public boolean isPenalty() {
        return this.penalty;
    }

    public int getPenaltyTime() {
        return this.penaltyTime;
    }

    public void setReplay(boolean bl) {
        this.replay = bl;
    }

    public void setReplayScaleFactor(float f) {
        this.replayScaleFactor = f;
    }

    public Team getTeam(boolean bl) {
        return !bl ? this.teamA : this.teamB;
    }

    public Team getTeam(int n) {
        return this.getTeam(n >= 6);
    }

    public int getScore(boolean bl) {
        return !bl ? this.scoreA : this.scoreB;
    }

    public GoalKeeper getGoalKeeper(boolean bl) {
        return this.getTeam(bl).getGoalKeeper();
    }

    public GoalKeeper getGoalKeeper(int n) {
        return this.getGoalKeeper(n >= 6);
    }

    public Player getPlayer(boolean bl, int n) {
        return this.getTeam(bl).getPlayer(n);
    }

    public Player getPlayer(int n) {
        return this.getPlayer(n >= 6, n % 6);
    }

    public void score(boolean bl) {
        if (!this.stopped) {
            if (bl) {
                ++this.scoreA;
                int n = this.period - 1;
                this.periodScoreA[n] = this.periodScoreA[n] + 1;
            } else {
                ++this.scoreB;
                int n = this.period - 1;
                this.periodScoreB[n] = this.periodScoreB[n] + 1;
            }
            int n = this.scoreRecord.length;
            int[] nArray = new int[n + 6];
            System.arraycopy(this.scoreRecord, 0, nArray, 0, n);
            nArray[n + 0] = this.time;
            nArray[n + 1] = bl ? 0 : 1;
            nArray[n + 2] = this.scoreA;
            nArray[n + 3] = this.scoreB;
            nArray[n + 4] = this.puck.getHolder();
            nArray[n + 5] = this.puck.getPasser();
            this.scoreRecord = nArray;
            this.stop(1);
        }
    }

    public void advance(int n) {
        if (this.stopped || this.finished) {
            this.stopTime += n;
        } else if (this.penalty) {
            this.penaltyTime -= n;
            if (this.penaltyTime < 0) {
                this.advancePeriod();
            }
        } else {
            this.time += n;
            if (this.time >= this.period * PERIOD_LENGTH * 1000) {
                this.advancePeriod();
            }
        }
    }

    public void advancePeriod() {
        if (this.period >= (Settings.getSinglePeriod() ? 1 : PERIODS) || Settings.getNoPeriods()) {
            if (Settings.getSudden() && !this.sudden && this.scoreA == this.scoreB || Settings.getPenalty() && (this.penalty || this.scoreA == this.scoreB)) {
                this.stop(2);
            } else {
                this.finish();
            }
        } else {
            this.stop(2);
        }
    }

    public boolean isNextSudden() {
        return this.period == PERIODS && Settings.getSudden() && this.scoreA == this.scoreB;
    }

    public boolean isNextPenalty() {
        return this.period >= PERIODS && !this.isNextSudden() && Settings.getPenalty() && (this.penalty || this.scoreA == this.scoreB);
    }

    public void stop(int n) {
        this.stop(n, 0.0, 0.0);
    }

    public void stop(int n, double d, double d2) {
        if (this.stopped) {
            return;
        }
        if (!(this.replay || !Settings.getDebug() && Settings.getGUI())) {
            switch (n) {
                case 1: {
                    System.out.println(this.scoreString(false, false));
                    break;
                }
                case 2: {
                    if (this.penalty || this.period <= 0) break;
                    System.out.println("End of period " + this.period);
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    System.out.println("Offside (" + this.timeString(false) + ")");
                    break;
                }
                case 5: {
                    System.out.println("Icing (" + this.timeString(false) + ")");
                    break;
                }
                case 6: 
                case 7: {
                    System.out.println("Pucken blockerad (" + this.timeString(false) + ")");
                }
            }
        }
        this.stopped = true;
        this.stopReason = n;
        this.resumeX = d;
        this.resumeY = d2;
    }

    public void resume() {
        if (this.stopReason == 3) {
            this.notifyAll();
            this.paused = true;
            return;
        }
        this.stopped = false;
        this.paused = false;
        this.stopTime = 0;
        if (this.stopReason == 2 && this.period < PERIODS + 2) {
            ++this.period;
        }
        if (this.stopReason == 2 && (this.period > PERIODS || this.period > 1 && Settings.getSinglePeriod())) {
            if (Settings.getSudden() && !this.sudden) {
                this.sudden = true;
            } else if (Settings.getPenalty()) {
                this.penalty = true;
            }
        }
        if (this.stopReason == 1 && this.sudden) {
            if (this.penalty) {
                this.stop(2);
            } else {
                this.finish();
            }
            return;
        }
        this.stopReason = 0;
        if (this.penalty) {
            this.penalty(this.penaltyPlayerA == 0 ? this.penaltyPlayerB - 6 - 1 : this.penaltyPlayerA + 6);
        } else {
            this.faceOff(this.resumeX, this.resumeY);
        }
    }

    public synchronized void finish() {
        this.finished = true;
        this.stop(3);
    }

    public void faceOff() {
        this.faceOff(0.0, 0.0);
    }

    public void faceOff(double d, double d2) {
        this.penalty = false;
        this.puck.faceOff(d, d2);
        this.teamA.faceOff(d, d2);
        this.teamB.faceOff(d, d2);
    }

    public void penalty(int n) {
        boolean bl;
        this.penalty = true;
        this.penaltyTime = 5000;
        boolean bl2 = bl = n >= 6;
        if ((n %= 6) < 1) {
            this.faceOff();
            this.finish();
            this.penalty = true;
            return;
        }
        this.penaltyPlayerA = bl ? 0 : n;
        this.penaltyPlayerB = (bl ? n : 0) + 6;
        this.puck.faceOff(0.0, 0.0);
        int n2 = 0;
        while (n2 < 12) {
            this.getPlayer(n2).moveTo(n2 * 100, 10000.0);
            ++n2;
        }
        int n3 = bl ? 1 : -1;
        this.getPlayer(bl ? 0 : 6).faceOff(0 + n3 * -2500, 0.0);
        this.getPlayer(n + (bl ? 6 : 0)).faceOff(n3 * 500, 0.0);
    }

    public boolean isPlayerPlaying(int n) {
        return !this.penalty || n == this.penaltyPlayerA || n == this.penaltyPlayerB;
    }

    public void test(double d, double d2) {
        double d3 = d - this.puck.getX();
        double d4 = d2 - this.puck.getY();
        this.puck.moveTo(d, d2);
        this.puck.setSpeed(d3, d4, 0.1);
    }

    public String teamStringA(boolean bl) {
        return bl ? this.teamA.getTeamName() : this.teamA.getShortName();
    }

    public String teamStringB(boolean bl) {
        return bl ? this.teamB.getTeamName() : this.teamB.getShortName();
    }

    public String teamString(boolean bl) {
        return this.teamStringA(bl) + " - " + this.teamStringB(bl);
    }

    public static String defaultTeamString(boolean bl) {
        return "";
    }

    public String periodNumberString(String string, String string2) {
        return this.penalty ? string2 : (this.sudden ? string : "(" + this.period + ")");
    }

    public String periodNameString(String string, String string2, String string3) {
        return this.penalty ? string : (this.sudden ? string2 : string3 + this.period);
    }

    public String nextPeriodNameString(String string, String string2, String string3) {
        return this.isNextPenalty() ? string : (this.isNextSudden() ? string2 : string3 + (this.period + 1));
    }

    public static String timeString(int n, boolean bl) {
        return "" + n / 60000 + ':' + n / 10000 % 6 + n / 1000 % 10 + (bl ? "." + n / 100 % 10 : "");
    }

    public String timeString(boolean bl) {
        return Game.timeString(this.time, bl);
    }

    public String replayString() {
        return this.replay && (this.time + this.stopTime) % 100 < 40 ? "R" : " ";
    }

    public String playerString(int n) {
        return this.playerString(n, false);
    }

    public String playerString(int n, boolean bl) {
        return this.playerString(n, bl, " ");
    }

    public String playerString(int n, boolean bl, String string) {
        if (n >= 0) {
            Player player = this.getPlayer(n);
            return "" + player.getNumber() + string + player.getName() + (bl ? string + "(" + this.getTeam(n).getTeamName() + ")" : "");
        }
        return "-";
    }

    public String scoreString(int n, boolean bl, int n2, int n3, int n4, int n5, boolean bl2, boolean bl3) {
        String string = "" + n2 + " - " + n3 + " (" + Game.timeString(n, bl) + ") " + this.playerString(n4, bl3, " ");
        if (!(n4 < 6 ^ n5 >= 6)) {
            n5 = -1;
        }
        string = !(bl2 ^ n4 < 6) ? string + " (" + this.playerString(n5, bl3, " ") + ")" : string + " (Sj\u00e4lvm\u00e5l)";
        return string;
    }

    public int getRecordLength() {
        return this.scoreRecord.length / 6;
    }

    public String scoreString(int n, boolean bl, boolean bl2) {
        return this.scoreString(this.scoreRecord[(n *= 6) + 0], bl, this.scoreRecord[n + 2], this.scoreRecord[n + 3], this.scoreRecord[n + 4], this.scoreRecord[n + 5], this.scoreRecord[n + 1] == 0, bl2);
    }

    public String scoreString(boolean bl, boolean bl2) {
        int n = this.scoreRecord.length / 6;
        return n > 0 ? this.scoreString(n - 1, bl, bl2) : "";
    }

    public String matchString() {
        return "" + this.scoreA + " - " + this.scoreB;
    }

    public static String defaultMatchString() {
        return "0 - 0";
    }

    public String periodScoreString() {
        String string = this.matchString();
        int n = PERIODS + (this.sudden ? 1 : 0) + (this.penalty ? 1 : 0);
        if (n <= 1) {
            return string;
        }
        if (n == 2) {
            --n;
        }
        string = string + " (";
        int n2 = 0;
        while (n2 < n) {
            if (n2 > 0) {
                string = string + ", ";
            }
            string = string + this.periodScoreA[n2] + " - " + this.periodScoreB[n2];
            ++n2;
        }
        return string + ")";
    }

    public void report() {
        int n = 0;
        while (n < this.getRecordLength()) {
            System.out.println(this.scoreString(n, true, false));
            ++n;
        }
        System.out.println(this.periodScoreString());
    }

    public void reportStats(PrintStream printStream) {
        printStream.println(this.scoreA + "   " + this.scoreB);
        printStream.println(this.teamA.getGoalKeeper().getShots() + "   " + this.teamB.getGoalKeeper().getShots());
        int n = 0;
        while (n < this.getRecordLength()) {
            printStream.println(this.scoreRecord[6 * n + 4] + " " + this.scoreRecord[6 * n + 5]);
            ++n;
        }
        int n2 = 0;
        while (n2 < 6) {
            printStream.println("" + this.teamA.getPlayer(n2).getUnfairness());
            ++n2;
        }
        int n3 = 0;
        while (n3 < 6) {
            printStream.println("" + this.teamB.getPlayer(n3).getUnfairness());
            ++n3;
        }
        printStream.flush();
    }

    public static void paintRink(Graphics2D graphics2D) {
        RINK.paintRink(graphics2D);
    }

    public static void drawMarkings(Graphics2D graphics2D) {
        RINK.drawMarkings(graphics2D);
        GOAL_A.paint(graphics2D);
        GOAL_B.paint(graphics2D);
    }

    public synchronized void paint(Graphics2D graphics2D) {
        this.puck.paint(graphics2D);
        this.teamA.paint(graphics2D);
        this.teamB.paint(graphics2D);
        if (this.replay && this.replayScaleFactor > 5.0f) {
            this.puck.paintReplay(graphics2D);
        } else if (Settings.getMarkPuck()) {
            this.puck.paintMark(graphics2D);
        }
        Thread.yield();
    }
}

