/*
 * Decompiled with CFR 0.152.
 */
package hockey.model;

import hockey.api.IGoalKeeper;
import hockey.api.IPlayer;
import hockey.api.IPuck;
import hockey.model.Game;
import hockey.model.IGoalKeeperImpl;
import hockey.model.IPlayerImpl;
import hockey.model.IPuckImpl;

public class IGame {
    private boolean side;
    private int time;
    private int scoreA;
    private int scoreB;
    private IPuckImpl puck;
    private IGoalKeeperImpl[] goalkeeper = new IGoalKeeperImpl[2];
    private IPlayerImpl[] player = new IPlayerImpl[12];

    public IGame(boolean bl) {
        this.side = bl;
        this.puck = new IPuckImpl(this);
        int n = 0;
        while (n < 12) {
            if (n % 6 == 0) {
                this.goalkeeper[n / 6] = new IGoalKeeperImpl(bl, n);
                this.player[n] = this.goalkeeper[n / 6];
            } else {
                this.player[n] = new IPlayerImpl(bl, n);
            }
            ++n;
        }
    }

    public void setGame(Game game) {
        this.time = game.getTime();
        this.scoreA = game.getScoreA();
        this.scoreB = game.getScoreB();
        this.puck.setPuck(game.getPuck());
        int n = 0;
        while (n < 12) {
            this.player[n].setPlayer(game.getPlayer(this.localIndex(n)), game);
            if (n % 6 == 0) {
                this.goalkeeper[n / 6].setGoalKeeper(game.getGoalKeeper(this.localIndex(n)), game);
            }
            ++n;
        }
    }

    public int getScore(boolean bl) {
        return bl ^ this.side ? this.scoreA : this.scoreB;
    }

    public boolean getSide() {
        return this.side;
    }

    public int getTime() {
        return this.time;
    }

    public IPuck getPuck() {
        return this.puck;
    }

    public IGoalKeeper getGoalKeeper(int n) {
        return this.goalkeeper[n >= 6 ? 1 : 0];
    }

    public IPlayer getPlayer(int n) {
        return this.player[n];
    }

    public int localIndex(int n) {
        return IGame.localIndex(n, this.side);
    }

    public static int localIndex(int n, boolean bl) {
        return n % 6 + (bl ^ n >= 6 ? 6 : 0);
    }
}

