/*
 * Decompiled with CFR 0.152.
 */
package hockey.model;

import hockey.Util;
import hockey.api.GoalKeeper;
import hockey.api.ITeam;
import hockey.model.Game;
import hockey.model.GoalKeeperImpl;
import hockey.model.IGame;
import hockey.model.Player;
import hockey.model.PlayerImpl;
import hockey.model.Team;
import java.awt.Color;

public class PlayerSetup {
    GoalKeeper[] goalkeeper = new GoalKeeper[2];
    hockey.api.Player[] player = new hockey.api.Player[12];
    GoalKeeperImpl[] goalkeeperimpl = new GoalKeeperImpl[2];
    PlayerImpl[] playerimpl = new PlayerImpl[12];
    Game game;
    IGame gameA;
    IGame gameB;
    ITeam teamA;
    ITeam teamB;
    boolean teamAtimeout;
    boolean teamBtimeout;

    public PlayerSetup(Game game, ITeam iTeam, ITeam iTeam2) {
        this.teamA = iTeam;
        this.teamB = iTeam2;
        this.gameA = new IGame(false);
        this.gameB = new IGame(true);
        this.setGame(game);
        PlayerSetupThread playerSetupThread = new PlayerSetupThread(iTeam, false);
        playerSetupThread.start();
        Util.await(playerSetupThread, 10000L);
        this.teamAtimeout = !playerSetupThread.terminated;
        PlayerSetupThread playerSetupThread2 = new PlayerSetupThread(iTeam2, true);
        playerSetupThread2.start();
        Util.await(playerSetupThread2, 10000L);
        this.teamBtimeout = !playerSetupThread2.terminated;
        this.ensureDifferentColours(game.getTeam(false), game.getTeam(true));
        this.ensureDifferentNames(game.getTeam(false), game.getTeam(true));
        this.ensureDifferentNumbers(false);
        this.ensureDifferentNumbers(true);
    }

    public boolean teamATimedOut() {
        return this.teamAtimeout;
    }

    public boolean teamBTimedOut() {
        return this.teamBtimeout;
    }

    public static boolean colorsEqual(Color color, Color color2) {
        return Util.sqr(color.getRed() - color2.getRed()) + Util.sqr(color.getGreen() - color2.getGreen()) + Util.sqr(color.getBlue() - color2.getBlue()) < 12288;
    }

    private static boolean colorsEqual(float[] fArray, float[] fArray2) {
        return Util.sqr(Math.IEEEremainder(fArray[0] - fArray2[0], 1.0)) + Util.sqr(fArray[1] - fArray2[1]) + Util.sqr(fArray[2] - fArray2[2]) < 0.025;
    }

    private static float[] colorToHSB(Color color) {
        return Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
    }

    private int colorNorm(Color color) {
        return Util.sqr(color.getRed()) + Util.sqr(color.getGreen()) + Util.sqr(color.getBlue());
    }

    /*
     * Unable to fully structure code
     */
    private void ensureDifferentColours(Team var1_1, Team var2_2) {
        block4: {
            var3_3 = var1_1.getColor();
            var4_4 = var1_1.getColor2();
            var5_5 = var2_2.getColor();
            var6_6 = var2_2.getColor2();
            if (!PlayerSetup.colorsEqual(var3_3, var5_5) && !PlayerSetup.colorsEqual(var4_4, var6_6)) {
                return;
            }
            if (!PlayerSetup.colorsEqual(var3_3, var6_6) && !PlayerSetup.colorsEqual(var4_4, var5_5)) {
                var2_2.setColor(var6_6);
                var2_2.setColor2(var5_5);
                return;
            }
            var7_7 = 0;
            if (this.colorNorm(var6_6) + this.colorNorm(var5_5) >= 98304) ** GOTO lbl20
            while ((PlayerSetup.colorsEqual(var5_5, var3_3) || PlayerSetup.colorsEqual(var6_6, var4_4)) && var7_7++ < 50) {
                var5_5 = var5_5.brighter();
                var6_6 = var6_6.brighter();
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                var5_5 = var5_5.darker();
                var6_6 = var6_6.darker();
lbl20:
                // 2 sources

                ** while ((PlayerSetup.colorsEqual((Color)var5_5, (Color)var3_3) || PlayerSetup.colorsEqual((Color)var6_6, (Color)var4_4)) && var7_7++ < 50)
            }
        }
        var2_2.setColor(var5_5);
        var2_2.setColor2(var6_6);
    }

    private void ensureDifferentNames(Team team, Team team2) {
        if (team2.getShortName() == team.getShortName()) {
            if (team2.getShortName().length() == 4) {
                team2.setShortName(team2.getShortName().substring(0, 3));
            } else {
                team2.setShortName(team2.getShortName() + "2");
            }
        }
    }

    private void ensureDifferentNumbers(boolean bl) {
        int n = 0;
        while (n < 6) {
            Player player = this.game.getPlayer(bl, n);
            int n2 = 0;
            while (n2 < n) {
                Player player2 = this.game.getPlayer(bl, n2);
                if (player.getNumber() == player2.getNumber()) {
                    player.setNumber((player.getNumber() + 1) % 100);
                    n2 = -1;
                }
                ++n2;
            }
            ++n;
        }
    }

    public void setGame(Game game) {
        this.game = game;
        this.gameA.setGame(game);
        this.gameB.setGame(game);
        int n = 0;
        while (n < 12) {
            if (this.playerimpl[n] != null) {
                this.playerimpl[n].setPlayer(game.getPlayer(n));
                if (n % 6 == 0) {
                    this.goalkeeperimpl[n / 6].setGoalKeeper(game.getGoalKeeper(n));
                }
            }
            ++n;
        }
    }

    public hockey.api.Player getPlayer(int n) {
        return this.player[n];
    }

    public ITeam getTeamA() {
        return this.teamA;
    }

    public ITeam getTeamB() {
        return this.teamB;
    }

    private void setupTeam(ITeam iTeam, boolean bl) {
        Team team = this.game.getTeam(bl);
        team.setShortName(iTeam.getShortName());
        if (team.getShortName().length() > 4) {
            team.setShortName(team.getShortName().substring(0, 4));
        }
        team.setTeamName(iTeam.getTeamName());
        team.setColor(iTeam.getTeamColor());
        team.setColor2(iTeam.getSecondaryTeamColor());
    }

    private void setupGoalKeeper(ITeam iTeam, IGame iGame, int n) {
        try {
            GoalKeeperImpl goalKeeperImpl = new GoalKeeperImpl(this.game.getGoalKeeper(n), iGame);
            int n2 = n / 6;
            this.goalkeeper[n2] = iTeam.getGoalKeeper();
            this.player[n] = this.goalkeeper[n2];
            this.goalkeeper[n2].setGoalKeeperControl(iGame.getGoalKeeper(0), goalKeeperImpl);
            this.goalkeeperimpl[n2] = goalKeeperImpl;
            this.fillPlayer(n, goalKeeperImpl);
        }
        catch (Throwable throwable) {
            this.handle(throwable);
        }
    }

    private void setupPlayer(ITeam iTeam, IGame iGame, int n) {
        try {
            PlayerImpl playerImpl = new PlayerImpl(this.game.getPlayer(n), iGame);
            this.player[n] = iTeam.getPlayer(n % 6);
            this.player[n].setPlayerControl(iGame.getPlayer(n % 6), playerImpl);
            this.fillPlayer(n, playerImpl);
        }
        catch (Throwable throwable) {
            this.handle(throwable);
        }
    }

    private void fillPlayer(int n, PlayerImpl playerImpl) {
        this.game.getPlayer(n).setNumber(this.player[n].getNumber());
        this.game.getPlayer(n).setName(this.player[n].getName());
        this.game.getPlayer(n).setLeftHanded(this.player[n].isLeftHanded());
        this.playerimpl[n] = playerImpl;
    }

    private void handle(Throwable throwable) {
        System.err.println("Player setup threw: " + throwable);
        throwable.printStackTrace();
    }

    class PlayerSetupThread
    extends Thread {
        boolean terminated;
        boolean side;
        ITeam team;

        PlayerSetupThread(ITeam iTeam, boolean bl) {
            this.team = iTeam;
            this.side = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            IGame iGame = this.side ? PlayerSetup.this.gameB : PlayerSetup.this.gameA;
            int n = this.side ? 6 : 0;
            this.terminated = false;
            PlayerSetup.this.setupTeam(this.team, this.side);
            PlayerSetup.this.setupGoalKeeper(this.team, iGame, n);
            int n2 = 1;
            while (n2 < 6) {
                PlayerSetup.this.setupPlayer(this.team, iGame, n + n2);
                ++n2;
            }
            this.terminated = true;
            PlayerSetupThread playerSetupThread = this;
            synchronized (playerSetupThread) {
                this.notifyAll();
            }
        }
    }
}

