/*
 * Decompiled with CFR 0.152.
 */
package hockey.model;

import hockey.Settings;
import hockey.Util;
import hockey.model.Game;
import hockey.model.GoalKeeper;
import hockey.model.IceObject;
import hockey.model.Outline;
import hockey.model.Player;
import hockey.model.Rink;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class Puck
extends IceObject {
    public static final double RADIUS = 3.75;
    public static final double MASS = 0.17;
    protected boolean held = false;
    protected int holder = -1;
    protected double lastX;
    protected double lastY;
    protected int lastT = -1;
    protected int passer = -1;
    protected transient Game game;
    private transient Outline innerRink = Rink.getOutline(100.0);
    private int ct;
    private double cx;
    private double cy;
    private boolean caught;
    private int caughtT;
    private transient boolean wasCaught;
    private int lastCaughtTime;
    private static Stroke STROKE = new BasicStroke(1.0f);
    private static Color MARK_COLOR = new Color(0.5f, 0.7f, 1.0f, 0.6f);

    public Puck() {
        super(3.75, 0.17);
        this.faceOff(0.0, 0.0);
    }

    public Puck(double d, double d2) {
        super(3.75, 0.17, d, d2);
        this.faceOff(d, d2);
    }

    public void faceOff(double d, double d2) {
        this.moveTo(d, d2);
        this.heading = Math.random() * 360.0;
        this.speed = 0.0;
        this.held = false;
        this.holder = -1;
        this.lastX = d;
        this.lastY = d2;
        this.lastT = -1;
        this.passer = -1;
    }

    public void setSpeed(double d, double d2, double d3) {
        this.heading = Util.datan2(d2, d);
        this.speed = Util.dist(d, d2) / d3;
    }

    public boolean isHeld() {
        return this.held || this.caught;
    }

    public int getHolder() {
        return this.holder;
    }

    public double getLastX() {
        return this.lastX;
    }

    public double getLastY() {
        return this.lastY;
    }

    public int getLastT() {
        return this.lastT;
    }

    public int getPasser() {
        return this.passer;
    }

    protected void simulationShape() {
        super.simulationShape();
        this.friction = 0.03;
        this.sideFriction = 0.03;
        this.bounceFactor = 0.4;
        this.airResistance = 0.2;
    }

    public void setGame(Game game) {
        this.game = game;
    }

    protected void goalCage(boolean bl) {
        this.game.score(bl);
    }

    protected void colliding(IceObject iceObject, double d) {
        this.game.getRules().puckColliding();
        if (iceObject instanceof GoalKeeper && !this.game.isStopped()) {
            ((GoalKeeper)iceObject).shotAt(this.game.getTime());
        }
    }

    void step(double d) {
        double d2 = this.x;
        double d3 = this.y;
        int n = this.getZone();
        super.step(d);
        int n2 = this.getZone();
        if (n != n2) {
            this.game.getRules().puckEnteredZone(n, n2, this.game);
        }
        if (this.game.stopped || Util.dist(this.cx - this.x, this.cy - this.y) > 105.0) {
            this.setPuckPos();
        }
        if (this.game.getTime() - this.ct > 1000) {
            int n3 = 0;
            int n4 = 0;
            while (n4 < 12) {
                Player player = this.game.getPlayer(n4);
                if (Util.dist(this.x - player.getX(), this.y - player.getY()) < 105.0) {
                    ++n3;
                }
                ++n4;
            }
            if (n3 < 1) {
                this.setPuckPos();
            }
        }
        if (this.game.getTime() - this.ct > 3000) {
            this.game.getRules().puckInactive(this.game);
        }
        if (this.caught && this.game.getTime() - this.caughtT > 2000) {
            this.game.getRules().puckBlocked(this.game);
        }
    }

    private void setPuckPos() {
        this.ct = this.game.getTime();
        this.cx = this.x;
        this.cy = this.y;
    }

    private int getZone() {
        int n = 1;
        if (Math.abs(this.x) > 2601.0 + this.r) {
            n = 3;
        } else if (Util.dist(2599.0 - Math.abs(this.x), this.y) < 180.0) {
            n = 4;
        } else if (Math.abs(this.x) > 881.0 + this.r) {
            n = 2;
        }
        return n *= this.x < 0.0 ? -1 : 1;
    }

    public void collision(int n, double d) {
        if (n == 0 || n == 6 || this.getZone() != (n < 6 ? -4 : 4)) {
            this.collision(this.game.getPlayer(n), d);
        }
    }

    public void follow(double d) {
        this.held = false;
        this.wasCaught = this.caught;
        this.caught = false;
        if (!this.game.isStopped()) {
            int n = 0;
            while (n < 12) {
                this.follow(n, d);
                ++n;
            }
        }
        if (this.caught && !this.wasCaught) {
            this.lastCaughtTime = this.game.getTime();
        } else if (this.caught && this.game.getTime() - this.lastCaughtTime > 3000) {
            this.game.getRules().puckBlocked(this.game);
        }
    }

    private void follow(int n, double d) {
        Player player = this.game.getPlayer(n);
        boolean bl = player.hasPuck(this);
        boolean bl2 = player.caughtPuck(this);
        if (bl || bl2) {
            if (this.holder != n) {
                this.passer = this.holder;
            }
            this.holder = n;
            this.held = true;
            this.lastX = this.x;
            this.lastY = this.y;
            this.lastT = this.game.getTime();
            if (bl2) {
                this.caught = true;
                if (!this.wasCaught) {
                    this.caughtT = this.game.getTime();
                }
            }
            if (!bl2 && this.holder >= 0 && this.holder != n && this.game.getPlayer(this.holder).hasPuck(this)) {
                Player player2 = this.game.getPlayer(this.holder);
                this.setSpeed(player.getStickDx() + player2.getStickDx(), player.getStickDy() + player2.getStickDy(), 2.0);
            } else {
                if (bl2) {
                    this.moveTo(player.getCatchX(), player.getCatchY());
                    this.setSpeed(player.getCatchDx(), player.getCatchDy(), 1.0);
                } else {
                    this.moveTo(player.getStickX(), player.getStickY());
                    this.setSpeed(player.getStickDx(), player.getStickDy(), 1.0);
                }
                if (player.isShooting()) {
                    player.setShotTime(player.getShotTime() + d);
                    if (player.getShotTime() >= player.getShotPower()) {
                        this.heading = player.getShotHeading();
                        this.speed = player.getShotSpeed();
                        player.setShooting(false);
                        player.setShotTime(0.0);
                        player.setStickSticky(false);
                    }
                }
            }
        } else {
            if (!player.getStickSticky()) {
                player.setStickSticky(true);
                bl = player.hasPuck(this);
                bl2 = player.caughtPuck(this);
                if (bl || bl2) {
                    player.setStickSticky(false);
                }
            }
            player.setShotTime(0.0);
            player.setShooting(false);
        }
    }

    public void paint(Graphics2D graphics2D) {
        super.paint(graphics2D);
        graphics2D.translate(this.getX(), this.getY());
        graphics2D.setStroke(STROKE);
        graphics2D.draw(this.shape);
        graphics2D.translate(-this.getX(), -this.getY());
        if (Settings.getTechnical() && Settings.getDebug()) {
            graphics2D.draw(Util.circle(this.cx, this.cy, 105.0));
            graphics2D.draw(Util.circle(this.cx, this.cy, (double)((3000 - (this.game == null ? 0 : this.game.getTime()) + this.ct) * 3) * 35.0 / 3000.0));
        }
    }

    public void paintReplay(Graphics2D graphics2D) {
        graphics2D.translate(this.getX(), this.getY());
        graphics2D.setStroke(STROKE);
        graphics2D.setColor(Color.YELLOW);
        graphics2D.scale(2.0, 2.0);
        graphics2D.draw(this.shape);
        graphics2D.scale(0.5, 0.5);
        graphics2D.translate(-this.getX(), -this.getY());
    }

    public void paintMark(Graphics2D graphics2D) {
        this.paint(graphics2D);
        graphics2D.translate(this.x, this.y);
        double d = 8.0;
        graphics2D.scale(d, d);
        graphics2D.setColor(MARK_COLOR);
        graphics2D.fill(this.shape);
        graphics2D.scale(1.0 / d, 1.0 / d);
        graphics2D.translate(-this.x, -this.y);
    }
}

