/*
 * Decompiled with CFR 0.152.
 */
package hockey.model;

import hockey.Util;
import hockey.model.Game;
import hockey.model.GameChangeListener;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Replay {
    public static final int FRAMES = 50;
    Game game;
    GameChangeListener main;
    Game[] frame = new Game[50];
    int current = 0;
    boolean replaying = false;
    int replay = 0;
    int replayStop = 0;
    float scaleFactor;
    boolean restoreMode = false;
    ObjectOutput out;
    ObjectInput in;

    public Replay(Game game, GameChangeListener gameChangeListener) {
        this.game = game;
        this.main = gameChangeListener;
    }

    private void setGame(Game game) {
        this.main.setGame(game);
    }

    public void setOutput(ObjectOutput objectOutput) {
        this.out = objectOutput;
    }

    public void setInput(ObjectInput objectInput) {
        this.in = objectInput;
    }

    public void restoreMode() {
        this.restoreMode = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log() {
        if (this.restoreMode) {
            this.restoreMode = this.restore();
        }
        Game game = this.game;
        synchronized (game) {
            try {
                this.frame[this.current] = (Game)this.game.clone();
                this.frame[this.current].setReplay(true);
                if (++this.current >= 50) {
                    this.current = 0;
                }
                this.replay = this.replayStop = this.current;
                if (this.out != null) {
                    this.out.writeObject((Game)this.game.clone());
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setReplay(int n, int n2, float f) {
        n = Util.clampPos(n, 49);
        n2 = Util.clampPos(n2, 50 - n - 1);
        this.replay = (this.current + 50 - n - n2) % 50;
        this.replayStop = (this.current + 50 - n2) % 50;
        this.scaleFactor = f;
        this.replay();
        this.replaying = true;
    }

    public boolean isReplaying() {
        return this.replaying;
    }

    public void replay() {
        if (this.replay == this.replayStop) {
            this.setGame(this.game);
            this.replaying = false;
        } else {
            if (this.frame[this.replay] != null) {
                this.frame[this.replay].setReplayScaleFactor(this.scaleFactor);
                this.setGame(this.frame[this.replay]);
            }
            if (++this.replay >= 50) {
                this.replay = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restore() {
        if (this.in == null) {
            return false;
        }
        try {
            this.game = (Game)this.in.readObject();
            this.setGame(this.game);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Replay replay = this;
        synchronized (replay) {
            this.notifyAll();
        }
        return false;
    }
}

