/*
 * Decompiled with CFR 0.152.
 */
package hockey.model;

import hockey.Util;
import hockey.model.Game;
import hockey.model.GameChangeListener;
import hockey.model.Player;
import hockey.model.Replay;

public class Simulation
implements Runnable,
GameChangeListener {
    public static final int T = 100;
    public static final int N = 15;
    public static final int G = 20;
    public static final int R = 7;
    public static final int IP = 70;
    public static final int P = 25;
    public static final int O = 12;
    public static final int OR = 4;
    public static final int I = 12;
    public static final int IR = 3;
    public static final int D = 15;
    public static final int DR = 3;
    public static final int F = 150;
    public static final int SLOW = 10;
    Game game;
    Game target;
    Replay replay;
    boolean facedoff;
    boolean penaltyShot;
    long time;
    boolean finished = false;
    int pairs = 0;
    private int[] pair = new int[132];

    public Simulation(Game game) {
        this.setGame(game);
    }

    public void setGame(Game game) {
        this.game = game;
    }

    public void setTarget(Game game) {
        this.target = game;
    }

    public void setReplay(Replay replay) {
        this.replay = replay;
    }

    public boolean facedOff() {
        boolean bl = this.facedoff;
        this.facedoff = false;
        return bl;
    }

    public boolean penaltyShot() {
        boolean bl = this.penaltyShot;
        this.penaltyShot = false;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.time = System.currentTimeMillis();
        while (!this.finished) {
            if (this.game.isStopped() || Util.timeInaccurate(this.time, 200L)) {
                this.time = System.currentTimeMillis();
            }
            this.step(true);
            if (this.replay != null && this.replay.isReplaying()) {
                this.replay.replay();
                continue;
            }
            if (this.target != null) {
                Game game = this.target;
                synchronized (game) {
                    this.game.copyTargetFrom(this.target);
                }
            }
            if (this.replay != null) {
                this.replay.log();
            }
            Simulation simulation = this;
            synchronized (simulation) {
                this.notifyAll();
            }
        }
    }

    public void stop() {
        this.finished = true;
    }

    private void findPairs() {
        double d = 0.1;
        int n = 0;
        int n2 = 1;
        while (n2 < 12) {
            if (this.game.isPlayerPlaying(n2)) {
                int n3 = 0;
                while (n3 < n2) {
                    Player player;
                    Player player2;
                    if (this.game.isPlayerPlaying(n3) && (player2 = this.game.getPlayer(n2)).getDist(player = this.game.getPlayer(n3)) < Math.max(player2.getR(), player2.getStickR()) + Math.max(player.getR(), player.getStickR()) + (player2.getSpeed() + player2.getSideSpeed() + player.getSpeed() + player.getSideSpeed()) * d) {
                        this.pair[n++] = n2;
                        this.pair[n++] = n3;
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        this.pairs = n;
    }

    private void step(boolean bl) {
        this.findPairs();
        if (bl) {
            int n = 0;
            while (n < 15) {
                this.subStep();
                this.time += 6L;
                if (this.replay != null && this.replay.isReplaying()) {
                    this.time += 60L;
                }
                Util.await(this.time);
                ++n;
            }
        } else {
            int n = 0;
            while (n < 15) {
                this.subStep();
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void subStep() {
        double d = 0.006666666666666667;
        Game game = this.game;
        synchronized (game) {
            if (!this.game.isPaused()) {
                int n = 0;
                while (n < this.pairs) {
                    Player player = this.game.getPlayer(this.pair[n]);
                    Player player2 = this.game.getPlayer(this.pair[n + 1]);
                    player.collision(player2, d);
                    n += 2;
                }
                this.game.getPuck().follow(d);
                int n2 = 0;
                while (n2 < 12) {
                    if (this.game.isPlayerPlaying(n2)) {
                        this.game.getPuck().collision(n2, d);
                        this.game.getPlayer(n2).step(d);
                    }
                    ++n2;
                }
                this.game.getPuck().step(d);
            }
            this.gameStep(6);
        }
    }

    private void gameStep(int n) {
        this.game.advance(n);
        if (this.game.isStopped()) {
            switch (this.game.getStopReason()) {
                case 1: {
                    if (this.game.getStopTime() <= 2000) break;
                    this.game.resume();
                    if (this.replay == null || this.replay.isReplaying()) break;
                    this.replay.setReplay(7, 18, 10.0f);
                    break;
                }
                case 2: {
                    if (this.game.getStopTime() <= (this.game.getPeriod() == 0 ? 70 : 25) * 100) break;
                    this.game.resume();
                    break;
                }
                case 3: {
                    if (this.game.getStopTime() <= 15000) break;
                    this.game.resume();
                    break;
                }
                case 4: {
                    if (this.game.getStopTime() <= 1200) break;
                    int n2 = (this.game.getStopTime() + 100) / 100;
                    this.game.resume();
                    if (this.replay == null || this.replay.isReplaying()) break;
                    this.replay.setReplay(4, n2, 1.5f);
                    break;
                }
                case 5: {
                    if (this.game.getStopTime() <= 1200) break;
                    this.game.resume();
                    break;
                }
                case 6: 
                case 7: {
                    if (this.game.getStopTime() <= 1500) break;
                    this.game.resume();
                    break;
                }
                case 8: {
                    this.game.resume();
                    break;
                }
                default: {
                    if (this.game.getStopTime() <= 1500) break;
                    this.game.resume();
                    if (this.replay == null || this.replay.isReplaying()) break;
                    this.replay.setReplay(3, 14, 5.0f);
                }
            }
            if (!this.game.isStopped()) {
                if (this.game.isPenalty()) {
                    this.penaltyShot = true;
                } else {
                    this.facedoff = true;
                }
            }
        }
    }
}

