/*
 * Decompiled with CFR 0.152.
 */
package hockey.model;

import hockey.model.GoalKeeper;
import hockey.model.Player;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.Serializable;

public class Team
implements Cloneable,
Serializable {
    public static final int N = 6;
    private boolean side;
    private Color color;
    private Color color2;
    private String shortName = "---";
    private String teamName = "Loading...";
    private GoalKeeper goalkeeper;
    private Player[] player = new Player[6];

    public Team(boolean bl) {
        this.side = bl;
        this.color = bl ? Color.WHITE : Color.WHITE;
        this.color2 = bl ? Color.WHITE : Color.WHITE;
        this.goalkeeper = new GoalKeeper(this);
        this.player[0] = this.goalkeeper;
        int n = 1;
        while (n < this.player.length) {
            this.player[n] = new Player(this);
            ++n;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Team team = (Team)super.clone();
        team.player = new Player[this.player.length];
        team.goalkeeper = (GoalKeeper)this.goalkeeper.clone();
        team.player[0] = team.goalkeeper;
        int n = 1;
        while (n < this.player.length) {
            team.player[n] = (Player)this.player[n].clone();
            ++n;
        }
        return team;
    }

    public void copyTargetFrom(Team team) {
        this.goalkeeper.copyTargetFrom(team.goalkeeper);
        int n = 1;
        while (n < this.player.length) {
            this.player[n].copyTargetFrom(team.player[n]);
            ++n;
        }
    }

    public boolean getSide() {
        return this.side;
    }

    public Color getColor() {
        return this.color;
    }

    public Color getColor2() {
        return this.color2;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getTeamName() {
        return this.teamName;
    }

    public GoalKeeper getGoalKeeper() {
        return this.goalkeeper;
    }

    public Player getPlayer(int n) {
        return this.player[n];
    }

    public void setSide(boolean bl) {
        this.side = bl;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setColor2(Color color) {
        this.color2 = color;
    }

    public void setShortName(String string) {
        this.shortName = string;
    }

    public void setTeamName(String string) {
        this.teamName = string;
    }

    public void faceOff(double d, double d2) {
        int n = this.side ? 1 : -1;
        this.player[0].faceOff(0 + n * 2500, 0.0);
        this.player[1].faceOff(d + (double)(n * 466), d2 + (double)(n * 151));
        this.player[2].faceOff(d + (double)(n * 466), d2 - (double)(n * 151));
        this.player[3].faceOff(d + (double)(n * 187), d2 + (double)(n * 452));
        this.player[4].faceOff(d + (double)(n * 187), d2 - (double)(n * 452));
        this.player[5].faceOff(d + (double)(n * 55), d2 + 0.0);
    }

    public void paint(Graphics2D graphics2D) {
        int n = 0;
        while (n < this.player.length) {
            this.player[n].paint(graphics2D, this);
            ++n;
        }
    }
}

