/*
 * Decompiled with CFR 0.152.
 */
package hockey.tournament;

import hockey.Arena;
import hockey.Settings;
import hockey.tournament.TeamEntry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class Match {
    TeamEntry team1;
    TeamEntry team2;
    int res1;
    int res2;
    boolean played;

    Match(TeamEntry teamEntry, TeamEntry teamEntry2) {
        this.team1 = teamEntry;
        this.team2 = teamEntry2;
    }

    Match(TeamEntry teamEntry, TeamEntry teamEntry2, int n, int n2) {
        this.team1 = teamEntry;
        this.team2 = teamEntry2;
        this.res1 = n;
        this.res2 = n2;
        this.processResult();
    }

    public TeamEntry getWinner() {
        return this.res1 > this.res2 ? this.team1 : this.team2;
    }

    public boolean isPlayed() {
        return this.played;
    }

    public TeamEntry getTeam(int n) {
        return n == 0 ? this.team1 : this.team2;
    }

    public int getScore(int n) {
        return n == 0 ? this.res1 : this.res2;
    }

    public void setTeam(int n, TeamEntry teamEntry) {
        if (n == 0) {
            this.team1 = teamEntry;
        } else {
            this.team2 = teamEntry;
        }
    }

    public void setScore(int n, int n2) {
        if (n == 0) {
            this.res1 = n2;
        } else {
            this.res2 = n2;
        }
    }

    protected void processResult() {
        if (this.played) {
            return;
        }
        this.team1.goodGoals += this.res1;
        this.team1.badGoals += this.res2;
        this.team2.goodGoals += this.res2;
        this.team2.badGoals += this.res1;
        int n = this.res1 - this.res2;
        if (n > 0) {
            ++this.team1.wins;
            ++this.team2.losses;
        } else if (n < 0) {
            ++this.team1.losses;
            ++this.team2.wins;
        } else {
            ++this.team1.draws;
            ++this.team2.draws;
        }
        this.played = true;
    }

    public void setResult(int n, int n2) {
        this.res1 = n;
        this.res2 = n2;
        this.processResult();
    }

    public void play(Arena arena) {
        if (this.played) {
            return;
        }
        try {
            arena.initGame(null);
            arena.startGame(this.team1.team, this.team2.team);
            arena.awaitGame();
            arena.getGame().report();
            String string = Settings.getStatsDir();
            if (string != null) {
                File file = new File(string);
                file.mkdir();
                arena.reportStats(new PrintStream(new FileOutputStream(File.createTempFile("stats", ".hockey", file))));
            }
            arena.finishGame();
            this.res1 = arena.getGame().getScoreA();
            this.res2 = arena.getGame().getScoreB();
            this.processResult();
        }
        catch (IOException iOException) {
            System.err.println("IOException:");
            iOException.printStackTrace();
        }
    }

    public void print(PrintStream printStream) {
        printStream.print(this.team1.name + " - " + this.team2.name);
        if (this.played) {
            printStream.print("\t" + this.res1 + " - " + this.res2);
        }
        printStream.println("");
    }
}

