/*
 * Decompiled with CFR 0.152.
 */
package hockey.tournament;

import hockey.display.Intermission;
import hockey.display.Text;
import hockey.tournament.Group;
import hockey.tournament.TeamEntry;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;

public class ScoreBoard
implements Intermission {
    static final float MARGIN = 0.9f;
    static final int FONTSIZE = 30;
    static final Color BLEND = new Color(255, 255, 255, 192);
    static final Font FONT = new Font("SansSerif", 1, 30);
    Group group;
    Text text;

    ScoreBoard(Group group) {
        this.group = group;
        this.text = new Text(FONT);
    }

    private void drawMessage(Graphics2D graphics2D, float f, float f2, float f3, int n, String string) {
        this.text.setText(string);
        this.text.setSpace(f3);
        this.text.draw(graphics2D, f, f2, n);
    }

    public void paint(Graphics2D graphics2D, int n, int n2) {
        float f = (float)(Math.min(n / 4, n2 / 3) * 4) * 0.9f;
        float f2 = (float)(Math.min(n / 4, n2 / 3) * 3) * 0.9f;
        float f3 = ((float)n - f) / 2.0f;
        float f4 = (n2 - 30 * (this.group.getTeams() + 1) - 10) / 2;
        graphics2D.setColor(BLEND);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setColor(Color.BLACK);
        graphics2D.translate(f3, f4);
        float f5 = 0.4f * f;
        float f6 = (f - f5) / 7.6f;
        if (this.group.isFinished()) {
            this.drawMessage(graphics2D, 0.0f, 0.0f, f, -1, "Final Standings");
        } else {
            this.drawMessage(graphics2D, 0.0f, 0.0f, f, -1, "Current Standings");
        }
        int n3 = 0;
        while (n3 < this.group.getTeams()) {
            TeamEntry teamEntry = this.group.getTeam(n3);
            int n4 = 30 * (n3 + 1) + 10;
            this.drawMessage(graphics2D, 0.0f, n4, f5, -1, teamEntry.name);
            this.drawMessage(graphics2D, f5 + f6, n4, f6, 1, Integer.toString(teamEntry.games()));
            this.drawMessage(graphics2D, f5 + 2.0f * f6, n4, f6, 1, Integer.toString(teamEntry.wins));
            this.drawMessage(graphics2D, f5 + 3.0f * f6, n4, f6, 1, Integer.toString(teamEntry.draws));
            this.drawMessage(graphics2D, f5 + 4.0f * f6, n4, f6, 1, Integer.toString(teamEntry.losses));
            this.drawMessage(graphics2D, f5 + 5.0f * f6, n4, f6, 1, Integer.toString(teamEntry.goodGoals));
            this.drawMessage(graphics2D, f5 + 5.3f * f6, n4, 0.6f * f6, 0, "-");
            this.drawMessage(graphics2D, f5 + 6.6f * f6, n4, f6, 1, Integer.toString(teamEntry.badGoals));
            this.drawMessage(graphics2D, f5 + 7.6f * f6, n4, f6, 1, Integer.toString(teamEntry.score()));
            ++n3;
        }
        graphics2D.translate(-f3, -f4);
    }
}

