/*
 * Decompiled with CFR 0.152.
 */
package hockey;

import java.awt.Dimension;

public class Settings {
    public static final int TEXTUI = 0;
    public static final int GUI = 1;
    public static final int IDE = 2;
    public static final int REAL = 0;
    public static final int TECHNICAL = 1;
    public static final int BOTH = 2;
    public static final int SINGLE = 0;
    public static final int NORMAL = 1;
    public static final int PLAYOFF = 2;
    public static final int PENALTY = 3;
    public static final int PLAY = 0;
    public static final int REC = 1;
    public static final int NOLOG = 2;
    private static int ui = 1;
    private static int draw = 0;
    private static boolean debug = false;
    private static Dimension screen = new Dimension(800, 450);
    private static boolean showNumbers = true;
    private static boolean playerDebug = false;
    private static int periodLength = 60;
    private static int playmode = 2;
    private static int logmode = 2;
    private static String logFile;
    private static String statsDir;
    private static boolean noScroll;
    private static boolean fullScreen;
    private static boolean markPuck;
    private static String hockeyPath;

    public static String getHockeyPath() {
        return hockeyPath;
    }

    public static boolean getGUI() {
        return ui >= 1;
    }

    public static boolean getIDE() {
        return ui == 2;
    }

    public static boolean getDebug() {
        return debug;
    }

    public static boolean getShowFPS() {
        return debug;
    }

    public static boolean getShowZoomSlider() {
        return debug && ui != 2;
    }

    public static Dimension getScreenSize() {
        return screen;
    }

    public static boolean getPlayerDebug() {
        return playerDebug;
    }

    public static boolean getReal() {
        return draw != 1;
    }

    public static boolean getTechnical() {
        return draw != 0;
    }

    public static boolean getShowNumbers() {
        return showNumbers;
    }

    public static boolean getNoPeriods() {
        return playmode == 3;
    }

    public static int getPeriodLength() {
        return periodLength;
    }

    public static boolean getSinglePeriod() {
        return playmode == 0;
    }

    public static boolean getSudden() {
        return playmode == 2;
    }

    public static boolean getPenalty() {
        return playmode >= 2;
    }

    public static boolean getLogPlay() {
        return logmode == 0;
    }

    public static boolean getLogRec() {
        return logmode == 1;
    }

    public static boolean getLogUsed() {
        return logmode < 2;
    }

    public static String getLogFile() {
        return logFile;
    }

    public static String getStatsDir() {
        return statsDir;
    }

    public static boolean getNoScroll() {
        return noScroll;
    }

    public static boolean getFullScreen() {
        return fullScreen;
    }

    public static boolean getMarkPuck() {
        return markPuck;
    }

    public static void setHockeyPath(String string) {
        hockeyPath = string;
    }

    public static void setReal(boolean bl) {
        draw = bl ? (draw != 0 ? 2 : 0) : 1;
    }

    public static void setTechnical(boolean bl) {
        draw = bl ? (draw != 1 ? 2 : 1) : 0;
    }

    public static void setPlayerDebug(boolean bl) {
        playerDebug = bl;
    }

    public static void setIDE(boolean bl) {
        ui = bl ? 2 : 1;
        screen = new Dimension(500, 375);
    }

    public static void setPenalty(boolean bl) {
        playmode = bl ? 3 : 2;
    }

    public static void setMarkPuck(boolean bl) {
        markPuck = bl;
    }

    public static int parse(String[] stringArray) {
        int n = 0;
        statsDir = null;
        while (n < stringArray.length && stringArray[n].charAt(0) == '-') {
            if (stringArray[n].equals("-options")) {
                System.err.println("Options:");
                System.err.println("  -fast");
                System.err.println("  -technical");
                System.err.println("  -single");
                System.err.println("  -penalty");
                System.err.println("  -log logfile");
                System.err.println("  -play logfile");
                System.err.println("  -noscroll");
                System.err.println("  -fullscreen");
                System.err.println("  -markpuck");
                System.err.println("  -stats dir");
                System.err.println("and others");
                System.exit(1);
            }
            if (stringArray[n].equals("-nogui")) {
                ui = 0;
            }
            if (stringArray[n].equals("-fast")) {
                showNumbers = false;
                screen = new Dimension(400, 300);
            }
            if (stringArray[n].equals("-debug")) {
                debug = true;
            }
            if (stringArray[n].equals("-technical")) {
                draw = 1;
            }
            if (stringArray[n].equals("-realandtechnical")) {
                draw = 2;
            }
            if (stringArray[n].equals("-single")) {
                playmode = 0;
            }
            if (stringArray[n].equals("-allowdraw")) {
                playmode = 1;
            }
            if (stringArray[n].equals("-penalty")) {
                playmode = 3;
            }
            if (stringArray[n].equals("-ide")) {
                Settings.setIDE(true);
            }
            if (stringArray[n].equals("-stats") && n + 1 < stringArray.length) {
                statsDir = stringArray[++n];
            }
            if (stringArray[n].equals("-log") && n + 1 < stringArray.length) {
                logmode = 1;
                logFile = stringArray[++n];
            }
            if (stringArray[n].equals("-play") && n + 1 < stringArray.length) {
                logmode = 0;
                logFile = stringArray[++n];
            }
            if (stringArray[n].equals("-perlen") && n + 1 < stringArray.length) {
                periodLength = Integer.parseInt(stringArray[++n]);
            }
            if (stringArray[n].equals("-playerdebug")) {
                playerDebug = true;
            }
            if (stringArray[n].equals("-noscroll")) {
                noScroll = true;
            }
            if (stringArray[n].equals("-fullscreen")) {
                fullScreen = true;
            }
            if (stringArray[n].equals("-markpuck")) {
                markPuck = true;
            }
            ++n;
        }
        return n;
    }

    static {
        noScroll = false;
        fullScreen = false;
        markPuck = false;
        hockeyPath = ".hockey";
    }
}

