/*
 * Decompiled with CFR 0.152.
 */
package hockey;

import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.util.Calendar;

public class Util {
    public static int sign(boolean bl) {
        return bl ? 1 : -1;
    }

    public static int sign(long l) {
        return l > 0L ? 1 : (l < 0L ? -1 : 0);
    }

    public static int sign(double d) {
        return d > 0.0 ? 1 : (d < 0.0 ? -1 : 0);
    }

    public static int sqr(int n) {
        return n * n;
    }

    public static long sqr(long l) {
        return l * l;
    }

    public static double sqr(double d) {
        return d * d;
    }

    public static double dist2(double d, double d2) {
        return d * d + d2 * d2;
    }

    public static double dist(double d, double d2) {
        return Math.sqrt(d * d + d2 * d2);
    }

    public static double dangle(double d, double d2) {
        return Math.IEEEremainder(d - d2, 360.0);
    }

    public static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    public static double deg(double d) {
        return d * 180.0 / Math.PI;
    }

    public static double cosd(double d) {
        return Math.cos(Util.rad(d));
    }

    public static double sind(double d) {
        return Math.sin(Util.rad(d));
    }

    public static double datan2(double d, double d2) {
        return Util.deg(Math.atan2(d, d2));
    }

    public static int clamp(int n, int n2, int n3) {
        return Math.min(Math.max(n, n2), n3);
    }

    public static double clamp(double d, double d2, double d3) {
        return Math.min(Math.max(d, d2), d3);
    }

    public static int clampPos(int n, int n2) {
        return Util.clamp(0, n, n2);
    }

    public static int clampAbs(int n, int n2) {
        return Util.clamp(-n2, n, n2);
    }

    public static double clampPos(double d, double d2) {
        return Util.clamp(0.0, d, d2);
    }

    public static double clampAbs(double d, double d2) {
        return Util.clamp(-d2, d, d2);
    }

    public static double solve(double d, double d2, double d3, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = Math.abs(d) < 1.0E-30;
        if (bl && bl2 && Math.abs(d2) > 1.0E-13) {
            return -d3 / 2.0 / d2;
        }
        double d4 = d2 * d2 - d * d3;
        if (bl2 || d4 < 0.0) {
            return Double.NaN;
        }
        return (-d2 + (double)(bl ? 1 : -1) * Math.sqrt(d4)) / d;
    }

    public static double collisionTime(double d, double d2, double d3, double d4, double d5) {
        return Util.solve(d4 * d4 + d5 * d5, d * d4 + d2 * d5, d * d + d2 * d2 - d3 * d3, false);
    }

    public static void sleep(long l) {
        if (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            Thread.yield();
        }
    }

    public static void await(long l) {
        Util.sleep(l - System.currentTimeMillis());
    }

    public static void await(Object object) {
        Util.await(object, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void await(Object object, long l) {
        if (object != null) {
            Object object2 = object;
            synchronized (object2) {
                try {
                    object.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public static boolean timeInaccurate(long l, long l2) {
        return Math.abs(l - System.currentTimeMillis()) > l2;
    }

    public static String timeString(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        int n3 = calendar.get(13);
        return "" + n / 10 + n % 10 + ':' + n2 / 10 + n2 % 10 + ':' + n3 / 10 + n3 % 10;
    }

    public static void stop(Thread thread) {
        thread.stop();
    }

    public static Shape draw(Shape shape, Stroke stroke) {
        return stroke.createStrokedShape(shape);
    }

    public static Line2D line(double d, double d2, double d3, double d4) {
        return new Line2D.Double(d, d2, d3, d4);
    }

    public static Ellipse2D circle(double d, double d2, double d3) {
        return new Ellipse2D.Double(d - d3, d2 - d3, d3 + d3, d3 + d3);
    }

    public static Arc2D arc(double d, double d2, double d3, double d4, double d5, int n) {
        return new Arc2D.Double(d - d3, d2 - d3, d3 + d3, d3 + d3, d4, d5, n);
    }

    public static int readInt(StreamTokenizer streamTokenizer) {
        try {
            while (streamTokenizer.nextToken() != -1 && streamTokenizer.ttype != -2) {
            }
            if (streamTokenizer.ttype == -1) {
                return -1;
            }
        }
        catch (IOException iOException) {
            return -1;
        }
        return (int)streamTokenizer.nval;
    }

    public static void copyStream(InputStream inputStream, PrintStream printStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                printStream.println(" | " + string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

