/*
 * Decompiled with CFR 0.152.
 */
package hockey.api;

import hockey.api.IGoalKeeper;
import hockey.api.IGoalKeeperControl;
import hockey.api.IObject;
import hockey.api.Player;
import hockey.api.Util;

public abstract class GoalKeeper
extends Player
implements IGoalKeeper,
IGoalKeeperControl {
    private IGoalKeeper impl;
    private IGoalKeeperControl ctrl;

    public final void setGoalKeeperControl(IGoalKeeper iGoalKeeper, IGoalKeeperControl iGoalKeeperControl) {
        super.setPlayerControl(iGoalKeeper, iGoalKeeperControl);
        this.impl = iGoalKeeper;
        this.ctrl = iGoalKeeperControl;
    }

    public int getGlide() {
        return this.impl == null ? 0 : this.impl.getGlide();
    }

    public IObject getGlove() {
        return this.impl == null ? null : this.impl.getGlove();
    }

    public int getTargetGlide() {
        return this.ctrl == null ? 0 : this.ctrl.getTargetGlide();
    }

    public void glide(int n) {
        if (this.ctrl != null) {
            this.ctrl.glide(n);
        }
    }

    public void skate(int n, int n2, int n3) {
        if (this.ctrl == null) {
            super.skate(n, n2, n3);
            return;
        }
        double d = Util.cosd(this.getHeading());
        double d2 = Util.sind(this.getHeading());
        int n4 = (int)Util.datan2(n2 - this.getY(), n - this.getX());
        int n5 = (int)((double)n3 * Util.cosd(n4));
        int n6 = (int)((double)n3 * Util.sind(n4));
        this.skate((int)(d * (double)n5 + d2 * (double)n6));
        this.glide((int)(d * (double)n6 - d2 * (double)n5));
    }

    public void skate(IObject iObject, int n) {
        this.skate(iObject.getX(), iObject.getY(), n);
    }
}

