/*
 * Decompiled with CFR 0.152.
 */
package hockey.display;

import hockey.Settings;
import hockey.Util;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.RGBImageFilter;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class Decor
implements ImageObserver {
    private String line;
    private Vector decor = new Vector();

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return true;
    }

    private boolean readLine(BufferedReader bufferedReader) throws IOException {
        this.line = bufferedReader.readLine();
        return this.line != null;
    }

    public void load() {
        this.decor.clear();
        String string = Settings.getHockeyPath() + "/decor";
        try {
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while (this.readLine(bufferedReader)) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.line);
                if (stringTokenizer.countTokens() != 5) continue;
                try {
                    Decal decal = new Decal(stringTokenizer, this);
                    this.decor.add(decal);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Decor parse error");
                }
            }
            fileReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("No " + string + " file");
        }
        catch (IOException iOException) {
            System.err.println("Decor " + iOException);
        }
    }

    public void paint(Graphics2D graphics2D) {
        Iterator iterator = this.decor.iterator();
        while (iterator.hasNext()) {
            ((Decal)iterator.next()).paint(graphics2D, this);
        }
    }

    private static class Decal {
        Image img;
        double x;
        double y;
        double w;
        double a;

        public Decal(StringTokenizer stringTokenizer, ImageObserver imageObserver) {
            String string = stringTokenizer.nextToken();
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image image = toolkit.createImage(string);
            IceFilter iceFilter = new IceFilter();
            this.img = toolkit.createImage(new FilteredImageSource(image.getSource(), iceFilter));
            this.x = Double.parseDouble(stringTokenizer.nextToken());
            this.y = Double.parseDouble(stringTokenizer.nextToken());
            this.w = Double.parseDouble(stringTokenizer.nextToken());
            this.a = Double.parseDouble(stringTokenizer.nextToken());
        }

        public void paint(Graphics2D graphics2D, ImageObserver imageObserver) {
            double d = this.w / (double)this.img.getWidth(imageObserver);
            graphics2D.translate(this.x, this.y);
            graphics2D.rotate(-Util.rad(this.a));
            graphics2D.scale(d, d);
            graphics2D.drawImage(this.img, -this.img.getWidth(imageObserver) / 2, -this.img.getHeight(imageObserver) / 2, imageObserver);
            graphics2D.scale(1.0 / d, 1.0 / d);
            graphics2D.rotate(Util.rad(this.a));
            graphics2D.translate(-this.x, -this.y);
        }
    }

    private static class IceFilter
    extends RGBImageFilter {
        public IceFilter() {
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int n, int n2, int n3) {
            return n3 + (0xFFFFFF - n3 >> 1 & 0x7F7F7F);
        }
    }
}

