/*
 * Decompiled with CFR 0.152.
 */
package hockey.display;

import hockey.Settings;
import hockey.Util;
import hockey.display.Intermission;
import hockey.display.Label;
import hockey.display.ScoreBoard;
import hockey.display.Slider;
import hockey.display.View;
import hockey.model.Game;
import hockey.model.GameChangeListener;
import hockey.model.Player;
import hockey.model.Replay;
import hockey.model.Rink;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JPanel;

public class Panel
extends JPanel
implements GameChangeListener {
    Game game;
    View view;
    Intermission intermission;
    ScoreBoard scoreboard;
    Slider slider;
    Label[] nameLabels;
    Label[] timeLabels;
    Label[] messageLabels;
    String[] lastMessage;
    private int frames = 0;
    private long millis = 0L;
    private int fps = 0;
    boolean faceOff = false;
    boolean test = false;
    int mousex;
    int mousey;

    public Panel(Game game) {
        this.game = game;
        this.view = new View(game);
        this.scoreboard = new ScoreBoard(game);
        this.slider = new Slider();
        this.setPreferredSize(Settings.getScreenSize());
        this.setBackground(Rink.LIGHTBLUE);
        this.addMouseListener(new Mouse());
        this.addMouseMotionListener(new Motion());
        if (Settings.getShowZoomSlider()) {
            this.add(this.slider);
        }
    }

    public void reloadDecor() {
        this.view.reloadDecor();
    }

    public void setGame(Game game) {
        this.game = game;
    }

    public void setIntermission(Intermission intermission) {
        this.intermission = intermission;
    }

    public void removeIntermission() {
        this.intermission = null;
    }

    public void setGameClone(Game game) {
        this.view.setGame(game);
        this.scoreboard.setGame(game);
    }

    public void setSlider(Slider slider) {
        this.slider = slider;
    }

    public void setLabels(Label[] labelArray, Label[] labelArray2, Label[] labelArray3) {
        this.nameLabels = labelArray;
        this.timeLabels = labelArray2;
        this.messageLabels = labelArray3;
        this.lastMessage = new String[this.messageLabels.length];
    }

    public void setPlayerNames() {
        if (this.nameLabels != null) {
            int n = 0;
            while (n < this.nameLabels.length) {
                if (this.nameLabels[n] != null) {
                    this.nameLabels[n].setText(this.game.playerString(n));
                }
                ++n;
            }
        }
        if (this.messageLabels != null) {
            int n = 0;
            while (n < this.messageLabels.length) {
                if (this.messageLabels[n] != null) {
                    this.messageLabels[n].setText(" ");
                }
                ++n;
            }
        }
        if (this.timeLabels != null) {
            int n = 0;
            while (n < this.timeLabels.length) {
                if (this.timeLabels[n] != null) {
                    this.timeLabels[n].setText(" ");
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics graphics) {
        Object object;
        if (this.game != null) {
            object = this.game;
            synchronized (object) {
                try {
                    this.setGameClone((Game)this.game.clone());
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    this.setGameClone(this.game);
                }
            }
        }
        super.paintComponent(graphics);
        object = (Graphics2D)graphics;
        ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
        ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
        ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT);
        ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT);
        ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
        int n = this.getWidth();
        int n2 = this.getHeight();
        ((Graphics2D)object).translate((double)n / 2.0, (double)n2 / 2.0);
        int n3 = Math.min(n, (n2 - 48) * 2);
        double d = (double)n3 / (Settings.getNoScroll() ? 6100.0 : 6400.0);
        ((Graphics2D)object).scale(d, d);
        this.view.scaleFactor = this.slider.getFactor();
        double d2 = (double)(n2 - 48) * 2.0 / (double)n3;
        this.view.paint((Graphics2D)object, d2);
        ((Graphics2D)object).scale(1.0 / d, 1.0 / d);
        ((Graphics2D)object).translate((double)(-n) / 2.0, (double)(-n2) / 2.0);
        if (this.intermission != null) {
            this.intermission.paint((Graphics2D)object, n, n2);
        } else {
            this.scoreboard.paint((Graphics2D)object, n, n2);
        }
        if (Settings.getShowFPS()) {
            ++this.frames;
            if (this.millis < System.currentTimeMillis() - 1000L) {
                this.fps = this.frames;
                this.frames = 0;
                this.millis = System.currentTimeMillis();
            }
            ((Graphics)object).setColor(Rink.BLUE);
            ((Graphics2D)object).drawString("" + this.fps + " fps", this.getWidth() - 100, 50);
        }
        if (this.game != null) {
            this.setGameClone(this.game);
            double d3 = (double)(this.mousex - this.getWidth() / 2) / 0.1;
            double d4 = (double)(this.mousey - this.getHeight() / 2) / 0.1;
            if (Settings.getDebug()) {
                if (this.faceOff) {
                    this.view.faceOff(d3, d4);
                    this.faceOff = false;
                } else if (this.test) {
                    this.view.test(d3, d4);
                }
            }
        }
        if (this.game != null && this.messageLabels != null) {
            int n4 = 0;
            while (n4 < this.messageLabels.length) {
                if (this.messageLabels[n4] != null && this.nameLabels[n4] != null) {
                    Player player = this.game.getPlayer(n4);
                    String string = player.getMessage();
                    if (string != null && !string.equals(this.lastMessage[n4])) {
                        this.timeLabels[n4].setText("(" + this.game.timeString(true) + ")");
                        if (!string.equals("")) {
                            this.messageLabels[n4].setText(string);
                        } else {
                            this.messageLabels[n4].setText(" ");
                        }
                    }
                    this.lastMessage[n4] = string;
                }
                ++n4;
            }
        }
        Util.sleep(20L);
        if (this.game != null) {
            this.repaint(20L);
        }
    }

    class Action
    implements ActionListener {
        Replay replay;

        public Action(Replay replay) {
            this.replay = replay;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.replay.setReplay(100, 0, 5.0f);
        }
    }

    class Motion
    extends MouseMotionAdapter {
        Motion() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Panel.this.test = true;
            Panel.this.mousex = mouseEvent.getX();
            Panel.this.mousey = mouseEvent.getY();
        }
    }

    class Mouse
    extends MouseAdapter {
        Mouse() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Panel.this.faceOff = true;
            Panel.this.mousex = mouseEvent.getX();
            Panel.this.mousey = mouseEvent.getY();
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Panel.this.test = false;
        }
    }
}

