/*
 * Decompiled with CFR 0.152.
 */
package hockey.display;

import hockey.Util;
import hockey.display.Intermission;
import hockey.display.Text;
import hockey.model.Game;
import hockey.model.Puck;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class ScoreBoard
implements Intermission {
    static final Color BACK = new Color(0.0f, 0.0f, 0.0f, 0.5f);
    public static final int H = 24;
    Game game;
    Color poss = new Color(0, 0, 0, 0);
    Shape scoreboard = ScoreBoard.makeScoreBoard();
    Shape timerboard = ScoreBoard.makeTimerBoard();
    Rectangle2D statusboard = new Rectangle2D.Double();
    static Font FONT = new Font("SansSerif", 1, 20);
    Text statusText = new Text(FONT);
    Text messageText = new Text(FONT);

    public ScoreBoard(Game game) {
        this.game = game;
    }

    public void setGame(Game game) {
        this.game = game;
    }

    private static Shape makeScoreBoard() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.lineTo(200.0f, 0.0f);
        generalPath.lineTo(188.0f, 24.0f);
        generalPath.lineTo(0.0f, 24.0f);
        generalPath.closePath();
        return generalPath;
    }

    private static Shape makeTimerBoard() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(-130.0f, 0.0f);
        generalPath.lineTo(0.0f, 0.0f);
        generalPath.lineTo(0.0f, 24.0f);
        generalPath.lineTo(-118.0f, 24.0f);
        generalPath.closePath();
        return generalPath;
    }

    private void drawMessage(Graphics2D graphics2D, float f, float f2, float f3, int n, String string) {
        this.messageText.setText(string);
        this.messageText.setSpace(f3);
        this.messageText.draw(graphics2D, f, f2, n);
    }

    public void paint(Graphics2D graphics2D, int n, int n2) {
        this.statusboard.setRect(0.0, n2 - 24, n, 24.0);
        graphics2D.setColor(BACK);
        graphics2D.fill(this.scoreboard);
        graphics2D.translate(n, 0);
        graphics2D.fill(this.timerboard);
        graphics2D.translate(-n, 0);
        graphics2D.setColor(this.poss);
        graphics2D.fill(this.statusboard);
        graphics2D.setColor(Color.WHITE);
        graphics2D.setFont(FONT);
        this.presentBase(graphics2D, n, n2);
        if (this.game != null && this.game.isStopped()) {
            int n3 = 0;
            String string = "???";
            String string2 = null;
            switch (this.game.getStopReason()) {
                case 1: {
                    string = "M\u00c5\u00c5\u00c5\u00c5L!!";
                    string2 = this.game.scoreString(false, false);
                    break;
                }
                case 2: {
                    if (this.game.getPeriod() == 0) {
                        string = this.game.teamString(true);
                        n3 = 170;
                        break;
                    }
                    string = this.game.getStopTime() < 1250 ? "Slut p\u00e5 " + this.game.periodNameString("f\u00f6rl\u00e4ngning", "straff", "period ") : this.game.nextPeriodNameString("F\u00f6rl\u00e4ngning", "Straffar", "Period ");
                    if (this.game.isNextSudden()) {
                        string = "F\u00f6rl\u00e4ngning";
                    }
                    if (!this.game.isNextPenalty()) break;
                    string = "Straffar";
                    break;
                }
                case 3: {
                    string = "Slut!";
                    string2 = this.game.periodScoreString();
                    n3 = 110;
                    break;
                }
                case 4: {
                    string = "Offside";
                    break;
                }
                case 5: {
                    string = "Icing";
                    break;
                }
                case 6: 
                case 7: {
                    string = "Pucken blockerad";
                    break;
                }
                case 8: {
                    string = "Tekning";
                }
            }
            this.drawMessage(graphics2D, n - 9, n2 - 3, (float)n * 0.3f, 1, string);
            if (this.game.isStopped() && !this.game.isReplay()) {
                if (string2 != null) {
                    n3 += 60;
                }
                graphics2D.setColor(this.poss);
                float f = 3.0f;
                graphics2D.scale(f, f);
                this.drawMessage(graphics2D, (float)(n / 2) / f, (float)((n2 + 21 - n3) / 2) / f, (float)n / f - 20.0f, 0, string);
                graphics2D.scale(1.0f / f, 1.0f / f);
                if (string2 != null) {
                    f = 2.0f;
                    graphics2D.scale(f, f);
                    this.drawMessage(graphics2D, (float)(n / 2) / f, (float)((n2 + 130 - n3) / 2) / f, (float)n / f - 20.0f, 0, string2);
                    graphics2D.scale(1.0f / f, 1.0f / f);
                }
                if (this.game.getPeriod() == 0) {
                    this.presentGame(graphics2D, n, n2, n3);
                }
                if (this.game.isFinished()) {
                    this.presentScores(graphics2D, n, n2, n3);
                }
            }
        }
    }

    private void presentBase(Graphics2D graphics2D, float f, float f2) {
        if (this.game != null) {
            graphics2D.drawString(this.game.teamString(false), 2, 18);
            graphics2D.drawString(this.game.matchString(), 125, 18);
        } else {
            graphics2D.drawString(Game.defaultTeamString(false), 2, 18);
            graphics2D.drawString(Game.defaultMatchString(), 125, 18);
        }
        if (this.game != null) {
            graphics2D.drawString(this.game.periodNumberString("(F)", "(S)") + " " + this.game.timeString(true) + " " + this.game.replayString(), f - 115.0f, 18.0f);
        } else {
            graphics2D.drawString("    " + Game.timeString(0, true), f - 115.0f, 18.0f);
        }
        if (this.game != null) {
            Puck puck = this.game.getPuck();
            int n = puck.getHolder();
            boolean bl = n >= 0 && (this.game.isStopped() ? this.game.getStopReason() == 1 : puck.isHeld());
            Color color = bl ? this.game.getTeam(n).getColor() : BACK;
            this.poss = new Color((this.poss.getRed() * 5 + color.getRed()) / 6, (this.poss.getGreen() * 5 + color.getGreen()) / 6, (this.poss.getBlue() * 5 + color.getBlue()) / 6, (this.poss.getAlpha() * 5 + (color == BACK && !this.game.isStopped() ? 0 : 192)) / 6);
            if (bl) {
                if (puck.isHeld()) {
                    this.statusText.setText(this.game.playerString(n, true, "  "));
                } else {
                    this.statusText.setText(this.game.scoreString(false, false));
                }
                this.statusText.setSpace(f * 0.7f);
                this.statusText.draw(graphics2D, 9.0f, f2 - 24.0f + 21.0f, -1);
            }
        }
    }

    private void presentGame(Graphics2D graphics2D, float f, float f2, int n) {
        int n2 = Util.clamp(0, this.game.getStopTime() / 700 - 1, 6);
        int n3 = 0;
        while (n3 < 2) {
            int n4 = 0;
            while (n4 < n2) {
                int n5 = n4 + n3 * 6;
                float f3 = f * (0.1f + (float)n3 * 0.5f);
                float f4 = (f2 - (float)n + 80.0f + (float)(60 * n4)) / 2.0f;
                this.messageText.setText("" + this.game.getPlayer(n5).getNumber());
                this.messageText.draw(graphics2D, f3 - 5.0f, f4, 1);
                this.drawMessage(graphics2D, f3 + 5.0f, f4, f * 0.35f, -1, this.game.getPlayer(n5).getName());
                ++n4;
            }
            ++n3;
        }
    }

    private void presentScores(Graphics2D graphics2D, float f, float f2, int n) {
        int n2 = this.game.getStopTime() / 70;
        int n3 = 0;
        while (n3 < this.game.getRecordLength()) {
            float f3 = f * 0.5f;
            float f4 = f2 - (float)n2 + (float)(30 * n3);
            if (f4 > (f2 - (float)n + 170.0f) / 2.0f) {
                this.drawMessage(graphics2D, f3, f4, f * 0.9f, 0, this.game.scoreString(n3, true, false));
            }
            ++n3;
        }
    }
}

