/*
 * Decompiled with CFR 0.152.
 */
package hockey.display;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.GlyphVector;

public class Text {
    public static final int LEFT = -1;
    public static final int CENTER = 0;
    public static final int RIGHT = 1;
    Font font;
    String text = "";
    int width = -1;
    GlyphVector glyphs = null;
    float space = -1.0f;

    public Text(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public String getText() {
        return this.text;
    }

    public void setFont(Font font) {
        this.font = font;
        this.width = -1;
    }

    public void setText(String string) {
        if (!this.text.equals(string)) {
            this.text = string;
            this.width = -1;
        }
    }

    public void validate(Graphics2D graphics2D) {
        if (this.width < 0) {
            graphics2D.setFont(this.font);
            this.width = graphics2D.getFontMetrics().stringWidth(this.text);
            this.glyphs = this.font.createGlyphVector(graphics2D.getFontRenderContext(), this.text);
        }
    }

    public int getWidth(Graphics2D graphics2D) {
        this.validate(graphics2D);
        return this.width;
    }

    public GlyphVector getGlyphs(Graphics2D graphics2D) {
        this.validate(graphics2D);
        return this.glyphs;
    }

    public void setSpace(float f) {
        this.space = f;
    }

    public void draw(Graphics2D graphics2D, float f, float f2, int n) {
        this.validate(graphics2D);
        float f3 = this.space > 0.0f && (float)this.width > this.space ? (float)this.width / this.space : 1.0f;
        graphics2D.scale(1.0f / f3, 1.0f / f3);
        graphics2D.drawGlyphVector(this.glyphs, n == -1 ? f * f3 : (n == 1 ? f * f3 - (float)this.width : f * f3 - (float)(this.width / 2)), f2 * f3);
        graphics2D.scale(f3, f3);
        this.space = -1.0f;
    }
}

