/*
 * Decompiled with CFR 0.152.
 */
package hockey.model;

import hockey.Util;
import hockey.model.Outline;
import hockey.model.Rink;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;

public class Goal {
    public static final int R = 50;
    public static final int L = 5;
    public static final int H = 91;
    private boolean side;
    private static Stroke STROKE = new BasicStroke(5.0f, 0, 0);
    private Shape goal;

    public Goal(boolean bl) {
        this.side = bl;
        this.goal = Goal.outset(bl, 0.0);
    }

    private static int getS(boolean bl) {
        return bl ? 1 : -1;
    }

    public static double getX(boolean bl) {
        return Goal.getX(Goal.getS(bl));
    }

    private static double getX(int n) {
        return n * 2600;
    }

    private static double getDx(double d, int n) {
        return (double)n * (d - Goal.getX(n));
    }

    private static double getDy(double d, double d2) {
        double d3 = d2 < 0.0 ? 91.0 : 41.0;
        return d > 0.0 ? d - d3 : d + d3;
    }

    public static Shape outset(boolean bl, double d) {
        double d2;
        GeneralPath generalPath = new GeneralPath();
        int n = Goal.getS(bl);
        float f = (float)Goal.getX(n);
        double d3 = 50.0 + (d += 5.0);
        double d4 = d2 = 41.0 < d3 ? Math.asin(41.0 / d3) * 180.0 / Math.PI : 90.0;
        if (d > 0.0) {
            generalPath.append(new Arc2D.Double((double)f - d, (double)(n * 91) - d, 2.0 * d, 2.0 * d, n * 90, 180.0, 0), false);
        }
        generalPath.append(new Arc2D.Double((double)f - d3, (double)(n * 41) - d3, 2.0 * d3, 2.0 * d3, n * -90, 90.0 + d2, 0), d > 0.0);
        generalPath.append(new Arc2D.Double((double)f - d3, (double)(-n * 41) - d3, 2.0 * d3, 2.0 * d3, bl ? -d2 : 180.0 - d2, 90.0 + d2, 0), true);
        if (d > 0.0) {
            generalPath.append(new Arc2D.Double((double)f - d, (double)(-n * 91) - d, 2.0 * d, 2.0 * d, n * 90, 180.0, 0), true);
        }
        generalPath.closePath();
        return generalPath;
    }

    public static boolean inGoalCage(boolean bl, double d, double d2, double d3) {
        double d4 = Goal.getDx(d2, bl ? 1 : -1);
        double d5 = Goal.getDy(d3, d4);
        return d4 > 0.0 && d4 < 50.0 && Util.dist(d4, d5) < 50.0;
    }

    public static Outline getOutline(boolean bl, double d) {
        return new GoalOutline(Goal.getS(bl), d);
    }

    public void paint(Graphics2D graphics2D) {
        graphics2D.setColor(Rink.RED);
        graphics2D.setStroke(STROKE);
        graphics2D.draw(this.goal);
    }

    private static class GoalOutline
    implements Outline {
        int s;
        double r;

        public GoalOutline(int n, double d) {
            this.s = n;
            this.r = d + 5.0;
        }

        public boolean contains(double d, double d2) {
            double d3 = Goal.getDx(d, this.s);
            double d4 = Goal.getDy(d2, d3);
            return Util.dist(d3, d4) < (d3 < 0.0 ? this.r : 50.0 + this.r);
        }

        public double getNormalX(double d, double d2) {
            double d3 = Goal.getDx(d, this.s);
            double d4 = Goal.getDy(d2, d3);
            if (d3 < 0.0 && Math.abs(d4) > this.r) {
                return -this.s;
            }
            return (double)this.s * d3 / Util.dist(d3, d4);
        }

        public double getNormalY(double d, double d2) {
            double d3 = Goal.getDx(d, this.s);
            double d4 = Goal.getDy(d2, d3);
            if (d3 < 0.0 && Math.abs(d4) > this.r) {
                return 0.0;
            }
            return d4 / Util.dist(d3, d4);
        }
    }
}

