/*
 * Decompiled with CFR 0.152.
 */
package hockey.model;

import hockey.Settings;
import hockey.Util;
import hockey.model.Player;
import hockey.model.Puck;
import hockey.model.Team;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;

public class GoalKeeper
extends Player {
    public static final double RADIUS = 40.0;
    public static final double MASS = 150.0;
    public static final double GLOVE_ANGLE = -60.0;
    public static final double GLOVE_R = 43.0;
    protected double targetSideSpeed;
    protected int shots;
    private static final double CATCH_FINGERS = 4.0;
    public static final double MAX_SIDE_SPEED = 333.0;
    public static final double GLOVE_TURN_SPEED = 450.0;
    public static final double GLOVE_SPEED = 277.0;
    private int lastShotTime = 0;
    protected static final double FINGER = 3.0;
    protected transient Shape glove;

    public GoalKeeper(Team team) {
        super(team);
        this.setR(40.0);
        this.setMass(150.0);
        this.shots = 0;
    }

    public void copyTargetFrom(GoalKeeper goalKeeper) {
        super.copyTargetFrom(goalKeeper);
        this.targetSideSpeed = goalKeeper.targetSideSpeed;
    }

    public void faceOff(double d, double d2) {
        super.faceOff(d, d2);
        this.targetSideSpeed = this.sideSpeed;
    }

    public double getTargetSideSpeed() {
        return this.targetSideSpeed;
    }

    public void setTargetSideSpeed(double d) {
        this.targetSideSpeed = d;
    }

    public double getGloveAbsoluteAngle() {
        return this.heading + (double)this.rightHanded * -60.0;
    }

    public double getGloveX() {
        return this.x + 43.0 * Util.cosd(this.getGloveAbsoluteAngle());
    }

    public double getGloveY() {
        return this.y + 43.0 * Util.sind(this.getGloveAbsoluteAngle());
    }

    public double getCatchX() {
        return this.getGloveX();
    }

    public double getCatchY() {
        return this.getGloveY();
    }

    public double getCatchDx() {
        return this.speed * Util.cosd(this.heading) - 43.0 * Util.rad(this.angular) * Util.sind(this.getGloveAbsoluteAngle());
    }

    public double getCatchDy() {
        return this.speed * Util.sind(this.heading) + 43.0 * Util.rad(this.angular) * Util.cosd(this.getGloveAbsoluteAngle());
    }

    public int getShots() {
        return this.shots;
    }

    public boolean hasPuck(Puck puck) {
        return super.hasPuck(puck) || this.caughtPuck(puck);
    }

    public boolean caughtPuck(Puck puck) {
        double d;
        if (!this.stickSticky) {
            return false;
        }
        double d2 = puck.getX() - this.getCatchX();
        double d3 = Util.collisionTime(d2, d = puck.getY() - this.getCatchY(), 15.75, puck.getDx(1.0) - this.getCatchDx(), puck.getDy(1.0) - this.getCatchDy());
        if (d3 > -0.001 && d3 < 0.006666666666666667) {
            return true;
        }
        return Util.dist(d2, d) < 15.75;
    }

    protected void simulationShape() {
        super.simulationShape();
        this.sideFriction = this.friction;
    }

    public void shotAt(int n) {
        if (n - this.lastShotTime < 250) {
            return;
        }
        ++this.shots;
        this.lastShotTime = n;
    }

    public void bouncing(double d) {
    }

    public void step(double d) {
        super.step(d);
        double d2 = Util.clampAbs(this.targetSideSpeed - this.sideSpeed, 444.0 * d);
        this.sideSpeed = Util.clampAbs(this.sideSpeed + d2, 333.0);
    }

    private Shape gloveShape() {
        GeneralPath generalPath = new GeneralPath();
        int n = -1;
        while (n <= 2) {
            generalPath.append(Util.arc(0.0, (double)(-n * 2) * 3.0, 3.0, -90.0, 180.0, 0), true);
            ++n;
        }
        generalPath.append(new Arc2D.Double(-6.0, -15.0, 12.0, 30.0, 90.0, 180.0, 0), true);
        generalPath.closePath();
        return generalPath;
    }

    protected void transientInit() {
        super.transientInit();
        this.glove = this.gloveShape();
    }

    public void paint(Graphics2D graphics2D, Team team) {
        super.paint(graphics2D, team);
        if (Settings.getTechnical()) {
            graphics2D.draw(Util.circle(this.getCatchX(), this.getCatchY(), 12.0));
        }
    }

    protected void paintGlove(Graphics2D graphics2D, Team team) {
        double d = Util.rad((double)this.rightHanded * -60.0);
        double d2 = Math.cos(d) * 43.0;
        double d3 = Math.sin(d) * 43.0;
        graphics2D.translate(d2, d3);
        graphics2D.setColor(team.getColor());
        graphics2D.fill(this.glove);
        graphics2D.setColor(Color.BLACK);
        graphics2D.setStroke(Player.BODY_STROKE);
        graphics2D.scale(1.0, this.rightHanded);
        graphics2D.draw(this.glove);
        graphics2D.scale(1.0, 1.0f / (float)this.rightHanded);
        graphics2D.translate(-d2, -d3);
    }
}

