/*
 * Decompiled with CFR 0.152.
 */
package hockey.model;

import hockey.Util;
import hockey.api.IGoalKeeperControl;
import hockey.model.GoalKeeper;
import hockey.model.IGame;
import hockey.model.PlayerImpl;

public class GoalKeeperImpl
extends PlayerImpl
implements IGoalKeeperControl {
    private GoalKeeper goalkeeper;

    public GoalKeeperImpl(GoalKeeper goalKeeper, IGame iGame) {
        super(goalKeeper, iGame);
        this.setGoalKeeper(goalKeeper);
        this.aimOnStick = false;
    }

    public void setGoalKeeper(GoalKeeper goalKeeper) {
        super.setPlayer(goalKeeper);
        this.goalkeeper = goalKeeper;
    }

    public int getTargetGlide() {
        return (int)this.goalkeeper.getTargetSideSpeed();
    }

    public void skate(int n) {
        this.goalkeeper.setTargetSpeed(Util.clampAbs(n, 444));
    }

    public void glide(int n) {
        this.goalkeeper.setTargetSideSpeed(Util.clampAbs(n, 444));
    }

    public void shoot(int n, int n2) {
        this.goalkeeper.shoot(this.localHeading(n), Util.clampAbs(n2, 1111));
    }
}

