/*
 * Decompiled with CFR 0.152.
 */
package hockey.model;

import hockey.Util;
import hockey.api.IObject;
import hockey.api.IPlayer;
import hockey.api.Position;
import hockey.model.Game;
import hockey.model.IGame;
import hockey.model.IObjectImpl;
import hockey.model.Player;
import hockey.model.Puck;

public class IPlayerImpl
extends IObjectImpl
implements IPlayer {
    protected Player player;
    protected Game game;
    protected int index;

    public IPlayerImpl(boolean bl, int n) {
        super(bl);
        this.index = n;
    }

    public void setPlayer(Player player, Game game) {
        super.setObject(player);
        this.player = player;
        this.game = game;
    }

    public int getStickAngle() {
        return (int)this.player.getStickAngle();
    }

    public int getStickR() {
        return (int)this.player.getStickR();
    }

    public int getStickX() {
        return this.s * (int)this.player.getStickX();
    }

    public int getStickY() {
        return this.s * (int)this.player.getStickY();
    }

    public IObject getStick() {
        double d = (double)this.s * this.player.getStickDx();
        double d2 = (double)this.s * this.player.getStickDy();
        return new Position(this.getStickX(), this.getStickY(), (int)Util.datan2(d2, d), (int)Util.dist(d, d2));
    }

    public boolean hasPuck() {
        Puck puck = this.game.getPuck();
        return puck.isHeld() && puck.getHolder() == IGame.localIndex(this.index, this.side);
    }

    public boolean isOpponent() {
        return this.index >= 6;
    }

    public boolean isLeftHanded() {
        return this.player.leftHanded();
    }

    public int getIndex() {
        return this.index;
    }
}

