/*
 * Decompiled with CFR 0.152.
 */
package hockey.model;

import hockey.Util;
import hockey.model.Goal;
import hockey.model.Outline;
import hockey.model.Rink;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.io.Serializable;

public class IceObject
implements Cloneable,
Serializable {
    protected double x;
    protected double y;
    protected double r;
    protected double heading;
    protected double speed;
    protected double sideSpeed;
    protected double angular;
    protected double mass;
    public static final double G = 981.0;
    protected transient double friction;
    protected transient double sideFriction;
    protected transient double bounceFactor;
    protected transient double glideFactor;
    protected transient double airResistance;
    protected transient Outline rink;
    protected transient Outline goalA;
    protected transient Outline goalB;
    protected transient Outline midgoalA;
    protected transient Outline midgoalB;
    protected transient Outline ingoalA;
    protected transient Outline ingoalB;
    protected transient Shape shape;

    IceObject(double d, double d2) {
        this(d, d2, 0.0, 0.0);
    }

    IceObject(double d, double d2, double d3, double d4) {
        this.setR(d);
        this.mass = d2;
        this.x = d3;
        this.y = d4;
        this.heading = Math.random() * 360.0;
        this.sideSpeed = 0.0;
        this.speed = 0.0;
        this.angular = 0.0;
        this.transientInit();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected Object readResolve() {
        this.transientInit();
        return this;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getR() {
        return this.r;
    }

    public double getHeading() {
        return this.heading;
    }

    public double getSpeed() {
        return this.speed;
    }

    public double getSideSpeed() {
        return this.sideSpeed;
    }

    public double getAngular() {
        return this.angular;
    }

    public double getMass() {
        return this.mass;
    }

    public void setX(double d) {
        this.x = d;
    }

    public void setY(double d) {
        this.y = d;
    }

    public void setR(double d) {
        this.r = d;
        this.bodyShape();
    }

    public void setHeading(double d) {
        this.heading = d;
    }

    public void setSpeed(double d) {
        this.speed = d;
    }

    public void setSideSpeed(double d) {
        this.sideSpeed = d;
    }

    public void setAngular(double d) {
        this.angular = d;
    }

    public void setMass(double d) {
        this.mass = d;
    }

    public void moveTo(double d, double d2) {
        this.setX(d);
        this.setY(d2);
    }

    public void moveRel(double d, double d2) {
        this.setX(this.x + d);
        this.setY(this.y + d2);
    }

    public double getDx(double d) {
        return Util.cosd(this.heading) * this.speed * d - Util.sind(this.heading) * this.sideSpeed * d;
    }

    public double getDy(double d) {
        return Util.sind(this.heading) * this.speed * d + Util.cosd(this.heading) * this.sideSpeed * d;
    }

    public void setSpeed(double d, double d2, double d3) {
        double d4 = Util.cosd(this.heading) / d3;
        double d5 = Util.sind(this.heading) / d3;
        this.speed = d4 * d + d5 * d2;
        this.sideSpeed = d4 * d2 - d5 * d;
        this.angular = Util.dangle(Util.datan2(d2, d) - this.heading, 0.0) * 0.5;
    }

    public double getDist(IceObject iceObject) {
        return this.getDist(iceObject.x, iceObject.y);
    }

    public double getDist(double d, double d2) {
        return Util.dist(d - this.x, d2 - this.y);
    }

    protected void simulationShape() {
        this.friction = 0.0;
        this.sideFriction = 1.0;
        this.bounceFactor = 1.0;
        this.glideFactor = 0.7;
        this.airResistance = 0.1;
        this.rink = Rink.getOutline(this.r);
        this.goalA = Goal.getOutline(false, this.r);
        this.goalB = Goal.getOutline(true, this.r);
        this.midgoalA = Goal.getOutline(false, -1.0);
        this.midgoalB = Goal.getOutline(true, -1.0);
        this.ingoalA = Goal.getOutline(false, -this.r - 1.0);
        this.ingoalB = Goal.getOutline(true, -this.r - 1.0);
    }

    protected void bouncing(double d) {
    }

    protected boolean bounce(Outline outline, boolean bl, double d, double d2, double d3) {
        if (outline.contains(this.x, this.y) ^ bl) {
            double d4 = outline.getNormalX(this.x, this.y);
            double d5 = this.getDx(d3);
            double d6 = outline.getNormalY(this.x, this.y);
            double d7 = this.getDy(d3);
            double d8 = d4 * d5 + d6 * d7;
            this.moveRel(-d5, -d7);
            d5 -= (1.0 + d) * d8 * d4;
            d7 -= (1.0 + d) * d8 * d6;
            d2 = Math.pow(d2, d3);
            this.setSpeed(d5 *= d2, d7 *= d2, d3);
            this.moveRel(d5, d7);
            int n = 0;
            int n2 = bl ? -1 : 1;
            while (outline.contains(this.x, this.y) ^ bl) {
                this.moveRel(d4 * (double)n2, d6 * (double)n2);
                if (++n <= 300) continue;
                System.err.println("Really bad bounce!!!");
                break;
            }
            this.bouncing(this.mass * (1.0 + d) * d8 / d3);
            return true;
        }
        return false;
    }

    void step(double d) {
        this.speed = Math.max(Math.abs(this.speed) - this.friction * 981.0 * d, 0.0) * (double)(this.speed > 0.0 ? 1 : -1) * (1.0 - this.airResistance * d);
        this.sideSpeed = Math.max(Math.abs(this.sideSpeed) - this.sideFriction * 981.0 * d, 0.0) * (double)(this.sideSpeed > 0.0 ? 1 : -1) * (1.0 - this.airResistance * d);
        this.setHeading(Util.dangle(this.heading + this.angular * d, 0.0));
        boolean bl = Math.abs(this.x) * 1.1 > Goal.getX(true) && (this.midgoalA.contains(this.x, this.y) || this.midgoalB.contains(this.x, this.y));
        double d2 = this.getDx(d);
        double d3 = this.getDy(d);
        this.moveRel(d2, d3);
        this.bounce(this.rink, true, this.bounceFactor, this.glideFactor, d);
        this.goalBounce(d, bl, false);
        this.goalBounce(d, bl, true);
    }

    private void goalBounce(double d, boolean bl, boolean bl2) {
        if (this.x * 1.1 > Goal.getX(bl2) ^ bl2) {
            return;
        }
        double d2 = 111.0;
        double d3 = 0.7;
        if (bl && this.x < Goal.getX(bl2) ^ bl2 && this.bounce(!bl2 ? this.ingoalA : this.ingoalB, true, this.bounceFactor / 3.0, d3, d)) {
            this.setSpeed(Math.min(this.speed, this.speed * 0.7 + d2 * 0.3));
        }
        if (this.getDx(d) <= 0.0 ^ bl2 && Goal.inGoalCage(bl2, this.r, this.x, this.y)) {
            this.goalCage(bl2);
        } else if (!bl) {
            this.bounce(!bl2 ? this.goalA : this.goalB, false, this.bounceFactor, d3, d);
        }
    }

    protected void goalCage(boolean bl) {
    }

    protected void colliding(IceObject iceObject, double d) {
    }

    void collision(IceObject iceObject, double d) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9 = this.r + iceObject.r;
        double d10 = this.getDist(iceObject);
        if (d10 < d9) {
            d8 = this.x - iceObject.x;
            d7 = this.y - iceObject.y;
            d6 = (d9 * 1.01 / Util.dist(d8, d7) - 1.0) / 2.0;
            this.moveRel(d8 * d6, d7 * d6);
            if (this.mass < 1.0) {
                this.moveRel(d8 * d6, d7 * d6);
            } else {
                iceObject.moveRel(-d8 * d6, -d7 * d6);
            }
        }
        if (d10 > d9 + (this.speed + iceObject.speed) * d + 3.0) {
            return;
        }
        d8 = this.x - iceObject.x;
        d7 = this.y - iceObject.y;
        d6 = this.getDx(d);
        double d11 = d6 - (d5 = iceObject.getDx(d));
        double d12 = Util.collisionTime(d8, d7, d9, d11, d4 = (d3 = this.getDy(d)) - (d2 = iceObject.getDy(d)));
        if (d12 >= 0.0 && d12 < 1.1) {
            double d13 = this.mass;
            double d14 = iceObject.mass;
            double d15 = (d6 * d13 + d5 * d14) / (d13 + d14);
            double d16 = (d3 * d13 + d2 * d14) / (d13 + d14);
            double d17 = 0.3;
            double d18 = 0.7;
            double d19 = d6 - d15;
            double d20 = d5 - d15;
            double d21 = d3 - d16;
            double d22 = d2 - d16;
            double d23 = (d8 + d12 * d11) / d9;
            double d24 = (d7 + d12 * d4) / d9;
            double d25 = d19 * d23 + d21 * d24;
            double d26 = d20 * d23 + d22 * d24;
            double d27 = d19 * d24 - d21 * d23;
            double d28 = d20 * d24 - d22 * d23;
            double d29 = d26 - d25;
            d25 = d14 * d29 / (d13 + d14) * d17;
            d26 = -d13 * d29 / (d13 + d14) * d17;
            double d30 = d14 * Util.dist(d5 - d15, d2 - d16) / d;
            double d31 = d13 * Util.dist(d6 - d15, d3 - d16) / d;
            d6 = d15 + d25 * d23 + (d27 *= d18) * d24;
            d3 = d16 + d25 * d24 - d27 * d23;
            d5 = d15 + d26 * d23 + (d28 *= d18) * d24;
            d2 = d16 + d26 * d24 - d28 * d23;
            this.setSpeed(d6, d3, d);
            iceObject.setSpeed(d5, d2, d);
            this.colliding(iceObject, d30);
            iceObject.colliding(this, d31);
        }
    }

    protected void transientInit() {
        this.simulationShape();
        this.bodyShape();
    }

    protected void bodyShape() {
        this.shape = new Ellipse2D.Double(-this.r, -this.r, 2.0 * this.r, 2.0 * this.r);
    }

    public void paint(Graphics2D graphics2D) {
        graphics2D.setColor(Color.BLACK);
        graphics2D.translate(this.x, this.y);
        graphics2D.fill(this.shape);
        graphics2D.translate(-this.x, -this.y);
    }
}

