/*
 * Decompiled with CFR 0.152.
 */
package hockey.model;

import hockey.Settings;
import hockey.Util;
import hockey.display.Text;
import hockey.model.Goal;
import hockey.model.GoalKeeper;
import hockey.model.IceObject;
import hockey.model.Outline;
import hockey.model.PlayerSetup;
import hockey.model.Puck;
import hockey.model.Rink;
import hockey.model.Team;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;

public class Player
extends IceObject {
    public static final double RADIUS = 35.0;
    public static final double MASS = 75.0;
    public static final double ACCELERATION = 444.0;
    public static final double BALANCING_TURN_SPEED = 90.0;
    public static final double ANGULAR_ACCELERATION = 720.0;
    public static final double MAX_ANGULAR = 360.0;
    public static final double STICK_TURN_SPEED = 450.0;
    public static final double STICK_SPEED = 144.0;
    protected int number = -1;
    protected String name = "loading..";
    protected boolean side;
    protected double turnSpeed;
    protected double stickAngle;
    protected double stickR;
    protected boolean stickSticky;
    protected int rightHanded;
    protected double totDimp;
    protected double targetSpeed;
    protected double targetHeading;
    protected double targetTurnSpeed;
    protected double targetStickAngle;
    protected double targetStickR;
    protected boolean shooting;
    protected double shotHeading;
    protected double shotSpeed;
    protected double shotPower;
    protected double shotTime;
    protected double phase = Math.random() * Math.PI;
    protected String message;
    protected static Outline stickRink = Rink.getOutline(1.0);
    protected static Outline stickGoalA = Goal.getOutline(false, 5.0);
    protected static Outline stickGoalB = Goal.getOutline(true, 5.0);
    protected static Stroke STICK_STROKE = new BasicStroke(4.0f, 0, 0);
    protected static Stroke BODY_STROKE = new BasicStroke(2.0f, 0, 0);
    protected static Font FONT = null;
    protected transient Text numberText;
    protected transient Line2D stick;
    protected transient Shape body;
    protected transient Shape head;
    private int debugPointX = 0;
    private int debugPointY = 0;
    private Color debugPointColor = Color.BLACK;
    private boolean debugPointVisible = false;

    public Player(Team team) {
        super(35.0, 75.0);
        this.side = team.getSide();
        this.rightHanded = 1;
        this.totDimp = 0.0;
        this.faceOff(0.0, 0.0);
    }

    public void copyTargetFrom(Player player) {
        this.targetSpeed = player.targetSpeed;
        this.targetHeading = player.targetHeading;
        this.targetTurnSpeed = player.targetTurnSpeed;
        this.targetStickAngle = player.targetStickAngle;
        this.targetStickR = player.targetStickR;
        this.shooting = player.shooting;
        this.shotHeading = player.shotHeading;
        this.shotSpeed = player.shotSpeed;
        this.shotPower = player.shotPower;
        this.message = player.message;
        this.debugPointX = player.debugPointX;
        this.debugPointY = player.debugPointY;
        this.debugPointColor = player.debugPointColor;
        this.debugPointVisible = player.debugPointVisible;
    }

    public void faceOff(double d, double d2) {
        this.moveTo(d, d2);
        this.targetHeading = this.side ? 180.0 : 0.0;
        this.heading = this.targetHeading;
        this.turnSpeed = 0.0;
        this.sideSpeed = 0.0;
        this.targetSpeed = 0.0;
        this.speed = 0.0;
        this.targetStickAngle = 69.0;
        this.stickAngle = 69.0;
        this.stickR = this.targetStickR = this.r + 25.0;
        this.stickSticky = true;
    }

    public double getUnfairness() {
        return this.totDimp;
    }

    public int getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public boolean getSide() {
        return this.side;
    }

    public double getStickAngle() {
        return this.stickAngle;
    }

    public double getStickR() {
        return this.stickR;
    }

    public boolean getStickSticky() {
        return this.stickSticky;
    }

    public double getTurnSpeed() {
        return this.turnSpeed;
    }

    public double getTargetSpeed() {
        return this.targetSpeed;
    }

    public double getTargetHeading() {
        return this.targetHeading;
    }

    public double getTargetTurnSpeed() {
        return this.targetTurnSpeed;
    }

    public double getTargetStickAngle() {
        return this.targetStickAngle;
    }

    public double getTargetStickR() {
        return this.targetStickR;
    }

    public boolean leftHanded() {
        return this.rightHanded == -1;
    }

    public boolean isShooting() {
        return this.shooting;
    }

    public double getShotHeading() {
        return this.shotHeading;
    }

    public double getShotSpeed() {
        return this.shotSpeed;
    }

    public double getShotPower() {
        return this.shotPower;
    }

    public double getShotTime() {
        return this.shotTime;
    }

    public double getPhase() {
        return this.phase;
    }

    public String getMessage() {
        return this.message;
    }

    public void setNumber(int n) {
        this.number = n;
        while (this.number < 0 || this.number > 99) {
            this.number = (this.number + 100) % 100;
        }
        this.numberText.setText("" + n);
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setStickAngle(double d) {
        this.stickAngle = d;
    }

    public void setStickR(double d) {
        this.stickR = d;
    }

    public void setStickSticky(boolean bl) {
        this.stickSticky = bl;
    }

    public void setTurnSpeed(double d) {
        this.turnSpeed = d;
    }

    public void setTargetSpeed(double d) {
        this.targetSpeed = d;
    }

    public void setTargetHeading(double d) {
        this.targetHeading = d;
    }

    public void setTargetTurnSpeed(double d) {
        this.targetTurnSpeed = d;
    }

    public void setTargetStickAngle(double d) {
        this.targetStickAngle = d;
    }

    public void setTargetStickR(double d) {
        this.targetStickR = d;
    }

    public void setLeftHanded(boolean bl) {
        this.rightHanded = bl ? -1 : 1;
    }

    public void shoot(double d, double d2) {
        this.shooting = true;
        this.shotHeading = d;
        this.shotSpeed = d2;
        this.shotPower = Util.dist(this.speed * Util.cosd(this.heading) - this.shotSpeed * Util.cosd(this.shotHeading), this.speed * Util.sind(this.heading) - this.shotSpeed * Util.sind(this.shotHeading)) / 15000.0;
    }

    public void setShooting(boolean bl) {
        this.shooting = bl;
    }

    public void setShotHeading(double d) {
        this.shotHeading = d;
    }

    public void setShotSpeed(double d) {
        this.shotSpeed = d;
    }

    public void setShotPower(double d) {
        this.shotPower = d;
    }

    public void setShotTime(double d) {
        this.shotTime = d;
    }

    public void setPhase(double d) {
        this.phase = d;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public double getStickAbsoluteAngle() {
        return this.heading + (double)this.rightHanded * this.stickAngle;
    }

    public double getStickX() {
        return this.x + this.stickR * Util.cosd(this.getStickAbsoluteAngle());
    }

    public double getStickY() {
        return this.y + this.stickR * Util.sind(this.getStickAbsoluteAngle());
    }

    public double getCatchX() {
        return this.getStickX();
    }

    public double getCatchY() {
        return this.getStickY();
    }

    public double getStickDx() {
        return this.speed * Util.cosd(this.heading) + Util.clampAbs(this.targetStickR - this.stickR, 144.0) * Util.cosd(this.getStickAbsoluteAngle()) - this.stickR * Util.rad(this.angular + Util.clampAbs((this.targetStickAngle - this.stickAngle) * (double)this.rightHanded, 450.0)) * Util.sind(this.getStickAbsoluteAngle());
    }

    public double getStickDy() {
        return this.speed * Util.sind(this.heading) + Util.clampAbs(this.targetStickR - this.stickR, 144.0) * Util.sind(this.getStickAbsoluteAngle()) + this.stickR * Util.rad(this.angular + Util.clampAbs((this.targetStickAngle - this.stickAngle) * (double)this.rightHanded, 450.0)) * Util.cosd(this.getStickAbsoluteAngle());
    }

    public double getCatchDx() {
        return this.getStickDx();
    }

    public double getCatchDy() {
        return this.getStickDy();
    }

    public boolean hasPuck(Puck puck) {
        return this.hasPuck(puck, (double)this.rightHanded * this.stickAngle, this.stickR);
    }

    public boolean caughtPuck(Puck puck) {
        return false;
    }

    public boolean hasPuck(Puck puck, double d, double d2) {
        if (!this.stickSticky) {
            return false;
        }
        double d3 = Util.rad(this.heading + d);
        double d4 = this.x + Math.cos(d3) * this.stickR - Math.sin(d3) * 9.0;
        double d5 = this.y + Math.sin(d3) * this.stickR + Math.cos(d3) * 9.0;
        double d6 = Util.collisionTime(puck.getX() - d4, puck.getY() - d5, puck.getR() + 10.0, puck.getDx(1.0) - this.getStickDx(), puck.getDy(1.0) - this.getStickDy());
        if (d6 > -0.001 && d6 < 0.006666666666666667) {
            return true;
        }
        return puck.getDist(d4, d5) < 10.0;
    }

    protected void simulationShape() {
        super.simulationShape();
        this.friction = 0.01;
        this.sideFriction = 0.9;
        this.bounceFactor = 0.1;
    }

    protected void bouncing(double d) {
        if (d > this.mass * 185.0) {
            this.stickSticky = false;
        }
    }

    public void step(double d) {
        super.step(d);
        double d2 = this.stickR;
        while (!stickRink.contains(this.getStickX(), this.getStickY()) || stickGoalA.contains(this.getStickX(), this.getStickY()) || stickGoalB.contains(this.getStickX(), this.getStickY())) {
            if (!(this.stickR > this.r)) break;
            this.stickR *= 0.99;
        }
        if (this.stickR <= this.r || (d2 - this.stickR) / d > 50.0) {
            this.stickSticky = false;
        }
        this.turnSpeed = this.targetTurnSpeed;
        double d3 = Util.dangle(this.targetHeading, this.heading);
        double d4 = Util.clampAbs((double)Util.sign(d3) * Math.sqrt(1440.0 * Math.abs(d3) / 7.0), this.turnSpeed);
        double d5 = Util.clampAbs(d4 - this.angular, 720.0 * d);
        this.angular = Util.clampAbs(this.angular + d5, 360.0);
        this.heading += Util.clampAbs(d3, 90.0 * d);
        double d6 = Util.clampAbs(this.targetSpeed - this.speed, 444.0 * d);
        this.speed += d6;
        double d7 = Util.clampAbs(this.targetStickAngle - this.stickAngle, 450.0 * d);
        this.stickAngle += d7;
        double d8 = Util.clampAbs(this.targetStickR - this.stickR, 144.0 * d);
        this.stickR += d8;
        this.phase += Math.abs(this.speed) / 300.0 * d;
    }

    protected void goalCage(boolean bl) {
        this.x = Goal.getX(bl);
        this.setSpeed(this.speed / 2.0 * (double)(bl ? -1 : 1), 0.0, 1.0);
    }

    protected void colliding(IceObject iceObject, double d) {
        if (iceObject instanceof Player) {
            this.totDimp += d;
        }
        if (!(iceObject instanceof GoalKeeper) && d > this.mass * 185.0) {
            this.stickSticky = false;
        }
    }

    void collision(Player player, double d) {
        super.collision(player, d);
        double d2 = this.stickR;
        while (Util.dist(this.getStickX() - player.x, this.getStickY() - player.y) < player.r) {
            if (!(this.stickR > this.r)) break;
            this.stickR *= 0.99;
        }
        if (this.stickR <= this.r || (d2 - this.stickR) / d > 50.0) {
            this.stickSticky = false;
        }
    }

    protected void transientInit() {
        super.transientInit();
        this.numberText = new Text(FONT);
        this.setNumber(this.number);
        this.stick = new Line2D.Double();
        this.bodyShape();
        this.head = new Arc2D.Double(-10.0, -20.0, 40.0, 40.0, 70.0, 220.0, 1);
    }

    protected void bodyShape() {
        super.bodyShape();
        this.body = new Ellipse2D.Double(-this.r + 5.0, -this.r - 3.0, 2.0 * this.r - 10.0, 2.0 * this.r + 6.0);
    }

    private double shotStickAngle() {
        double d = this.shotPower * 40.0;
        double d2 = this.shotTime / (this.shotPower + 0.001);
        double d3 = 0.8;
        if (d2 < d3) {
            return d * d2 / d3;
        }
        return d * (1.0 - (d2 - d3) / (1.0 - d3));
    }

    public void setDebugPoint(int n, int n2, Color color) {
        this.debugPointX = n;
        this.debugPointY = n2;
        this.debugPointColor = color;
    }

    public void showDebugPoint(boolean bl) {
        this.debugPointVisible = bl;
    }

    public void paint(Graphics2D graphics2D, Team team) {
        if (Settings.getTechnical()) {
            graphics2D.setColor(team.getColor());
            graphics2D.fill(Util.circle(this.x, this.y, this.r));
        }
        if (Settings.getReal()) {
            graphics2D.translate(this.x, this.y);
            graphics2D.rotate(Util.rad(this.heading));
            graphics2D.setColor(Color.BLACK);
            graphics2D.setStroke(STICK_STROKE);
            this.stick.setLine(Math.cos(this.phase) * -10.0 - this.r * 0.7, 10.0, Math.cos(this.phase) * -10.0 + this.r * 0.7, 10.0);
            graphics2D.draw(this.stick);
            this.stick.setLine(Math.cos(this.phase) * 10.0 - this.r * 0.7, -10.0, Math.cos(this.phase) * 10.0 + this.r * 0.7, -10.0);
            graphics2D.draw(this.stick);
            graphics2D.setColor(team.getColor());
            graphics2D.fill(this.body);
            graphics2D.setColor(Color.BLACK);
            graphics2D.setStroke(BODY_STROKE);
            graphics2D.draw(this.body);
            this.paintStick(graphics2D);
            this.paintGlove(graphics2D, team);
            double d = Util.rad(Util.clamp(-45.0, Util.dangle(this.targetHeading, this.heading), 45.0));
            graphics2D.translate(10, 0);
            graphics2D.rotate(d);
            graphics2D.setColor(team.getColor2());
            graphics2D.fill(this.head);
            graphics2D.setColor(Color.BLACK);
            graphics2D.setStroke(BODY_STROKE);
            graphics2D.draw(this.head);
            graphics2D.rotate(-d);
            graphics2D.translate(-10, 0);
            graphics2D.setColor(Color.BLACK);
            graphics2D.rotate(1.5707963267948966);
            graphics2D.scale(1.0, 0.5);
            if (Settings.getShowNumbers()) {
                if (PlayerSetup.colorsEqual(Color.BLACK, team.getColor())) {
                    graphics2D.setColor(Color.WHITE);
                }
                this.numberText.draw(graphics2D, 0.0f, 37.0f, 0);
                graphics2D.setColor(Color.BLACK);
            }
            graphics2D.scale(1.0, 2.0);
            graphics2D.rotate(-1.5707963267948966 - Util.rad(this.heading));
            graphics2D.translate(-this.x, -this.y);
        }
        if (Settings.getTechnical()) {
            graphics2D.setStroke(BODY_STROKE);
            graphics2D.setColor(Color.BLACK);
            graphics2D.draw(Util.circle(this.x, this.y, this.r));
            graphics2D.draw(Util.line(this.x, this.y, this.getStickX(), this.getStickY()));
        }
        if (Settings.getPlayerDebug() && this.debugPointVisible) {
            graphics2D.setColor(this.debugPointColor);
            graphics2D.draw(Util.line(this.x, this.y, this.debugPointX, this.debugPointY));
            graphics2D.fill(Util.circle(this.debugPointX, this.debugPointY, 2.0));
            graphics2D.setColor(Color.BLACK);
        }
    }

    protected void paintStick(Graphics2D graphics2D) {
        graphics2D.setColor(Color.BLACK);
        graphics2D.setStroke(STICK_STROKE);
        double d = Util.rad((double)this.rightHanded * (this.stickAngle + this.shotStickAngle()));
        this.stick.setLine((double)this.rightHanded * Math.sin(d) * this.r * 0.6, (double)(-this.rightHanded) * Math.cos(d) * this.r * 0.9, Math.cos(d) * (this.stickR + 3.0) - (double)this.rightHanded * Math.sin(d) * 6.75, Math.sin(d) * (this.stickR + 3.0) + (double)this.rightHanded * Math.cos(d) * 6.75);
        graphics2D.draw(this.stick);
    }

    protected void paintGlove(Graphics2D graphics2D, Team team) {
    }

    static {
        try {
            FONT = new Font("SansSerif", 1, 48);
        }
        catch (InternalError internalError) {
            // empty catch block
        }
    }
}

