/*
 * Decompiled with CFR 0.152.
 */
package hockey.model;

import hockey.Util;
import hockey.api.IGoalKeeper;
import hockey.api.IPlayer;
import hockey.api.IPlayerControl;
import hockey.api.IPuck;
import hockey.model.IGame;
import hockey.model.IObjectImpl;
import hockey.model.Player;
import java.awt.Color;

public class PlayerImpl
extends IObjectImpl
implements IPlayerControl {
    private Player player;
    protected boolean aimOnStick;
    protected IGame igame;

    public PlayerImpl(Player player, IGame iGame) {
        super(iGame.getSide());
        this.igame = iGame;
        this.setPlayer(player);
        this.aimOnStick = true;
    }

    public void setPlayer(Player player) {
        super.setObject(player);
        this.player = player;
    }

    public int getNumber() {
        return this.player.getNumber();
    }

    public String getName() {
        return this.player.getName();
    }

    public boolean getAimOnStick() {
        return this.aimOnStick;
    }

    public int getTargetSpeed() {
        return (int)this.player.getTargetSpeed();
    }

    public int getTargetHeading() {
        return this.localHeading(this.player.getTargetHeading());
    }

    public int getTurnSpeed() {
        return (int)this.player.getTurnSpeed();
    }

    public int getTargetStickAngle() {
        return (int)this.player.getTargetStickAngle();
    }

    public int getTargetStickR() {
        return (int)this.player.getTargetStickR();
    }

    public void setAimOnStick(boolean bl) {
        this.aimOnStick = bl;
    }

    public void skate(int n) {
        this.player.setTargetSpeed(Util.clampAbs(n, 1111));
    }

    public void turn(int n, int n2) {
        this.player.setTargetHeading(this.localHeading(n));
        this.player.setTargetTurnSpeed(Util.clampPos(Math.abs(n2), 180));
    }

    public void moveStick(int n, int n2) {
        this.player.setTargetStickAngle(Util.clamp(0, n, 135));
        this.player.setTargetStickR(Util.clamp(40, n2, 70));
    }

    public void shoot(int n, int n2) {
        this.player.shoot(this.localHeading(n), Util.clampAbs(n2, 4444));
    }

    public int getScore(boolean bl) {
        return this.igame.getScore(bl);
    }

    public IPuck getPuck() {
        return this.igame.getPuck();
    }

    public IGoalKeeper getGoalKeeper(int n) {
        return this.igame.getGoalKeeper(n);
    }

    public IPlayer getPlayer(int n) {
        return this.igame.getPlayer(n);
    }

    public void setMessage(String string) {
        this.player.setMessage(string);
    }

    public void setDebugPoint(int n, int n2, Color color) {
        this.player.setDebugPoint(this.s * n, this.s * n2, color);
    }

    public void showDebugPoint(boolean bl) {
        this.player.showDebugPoint(bl);
    }
}

