/*
 * Decompiled with CFR 0.152.
 */
package hockey.model;

import hockey.Util;
import hockey.model.Outline;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.RoundRectangle2D;

public class Rink {
    public static final int W = 6000;
    public static final int H = 3000;
    public static final int O = 1400;
    public static final int R = 850;
    public static final int D1 = 600;
    public static final int C = 450;
    public static final int D = 400;
    public static final int F = 300;
    public static final int G = 180;
    public static final int D2 = 150;
    public static final int T = 60;
    public static final int M = 50;
    public static final int A = 1733;
    public static final int L1 = 30;
    public static final int T1 = 35;
    public static final int L2 = 5;
    public static final int U1 = 170;
    public static final int U2 = 60;
    public static final int V1 = 30;
    public static final int V2 = 90;
    public static final int W1 = 45;
    public static final int W2 = 120;
    public static final int G2 = 183;
    public static final int GH = 252;
    public static final int GW = 122;
    public static final int GL = 15;
    public static final Color BLACK = Color.BLACK;
    public static final Color RED = new Color(239, 50, 35);
    public static final Color BLUE = new Color(0, 123, 195);
    public static final Color LIGHTBLUE = new Color(173, 200, 232);
    public static final Color WHITE = Color.WHITE;
    private static Stroke stroke1 = new BasicStroke(30.0f, 0, 0);
    private static Stroke stroke2 = new BasicStroke(5.0f, 0, 0);
    private Shape rink = Rink.inset(0.0);
    private Shape rink2 = Rink.inset(-2.0);
    private Shape goalLineA = this.goalLine(-2600);
    private Shape blueLineA = Util.line(-866.0, -1500.0, -866.0, 1500.0);
    private Shape midLineU = Util.line(0.0, -1500.0, 0.0, -25.0);
    private Shape midDot = Util.circle(0.0, 0.0, 15.0);
    private Shape midLineL = Util.line(0.0, 25.0, 0.0, 1500.0);
    private Shape blueLineB = Util.line(866.0, -1500.0, 866.0, 1500.0);
    private Shape goalLineB = this.goalLine(2600);
    private Shape goalAreaA = Util.arc(-2600.0, 0.0, 180.0, -90.0, 180.0, 0);
    private Shape goalArcA = Util.arc(-2600.0, 0.0, 178.0, -90.0, 180.0, 0);
    private Shape goalArcB = Util.arc(2600.0, 0.0, 178.0, 90.0, 180.0, 0);
    private Shape goalAreaB = Util.arc(2600.0, 0.0, 180.0, 90.0, 180.0, 0);
    private Shape dropCircle = Util.circle(0.0, 0.0, 448.0);
    private Shape dropDot = this.dripDot();
    private Shape dropLines = this.dripLines();
    private Shape refereeCircle = Util.arc(0.0, -1500.0, 300.0, 180.0, 180.0, 0);
    private Shape goalMarks = this.marks();
    public static int[] dropX = new int[]{-2000, 2000, -716, 716};

    private static Shape inset(double d) {
        return new RoundRectangle2D.Double(-3000.0 + d, -1500.0 + d, 6000.0 - 2.0 * d, 3000.0 - 2.0 * d, 2.0 * (850.0 - d), 2.0 * (850.0 - d));
    }

    public static Outline getOutline(double d) {
        return new RinkOutline(d);
    }

    private Shape goalLine(int n) {
        double d = 650.0 + Math.sqrt(520000.0);
        return new Line2D.Double(n, -d, n, d);
    }

    private Shape dripDot() {
        GeneralPath generalPath = new GeneralPath(0);
        generalPath.append(new Ellipse2D.Double(-30.0, -30.0, 60.0, 60.0), false);
        double d = 25.0;
        double d2 = Math.sqrt(d * d - 306.25);
        double d3 = Math.asin(d2 / d) * 180.0 / Math.PI;
        generalPath.append(new Arc2D.Double(-d, -d, 2.0 * d, 2.0 * d, -d3, 2.0 * d3, 1), false);
        generalPath.append(new Arc2D.Double(-d, -d, 2.0 * d, 2.0 * d, 180.0 - d3, 2.0 * d3, 1), false);
        return generalPath;
    }

    private Shape dripLines() {
        float f = (float)Math.sqrt(195275.0);
        GeneralPath generalPath = new GeneralPath();
        int n = -1;
        while (n <= 1) {
            int n2 = -1;
            while (n2 <= 1) {
                generalPath.moveTo((float)(n * 170) / 2.0f, (float)n2 * (f + 60.0f));
                generalPath.lineTo((float)(n * 170) / 2.0f, (float)n2 * f);
                generalPath.moveTo((float)n * 60.0f, (float)n2 * 112.5f);
                generalPath.lineTo((float)n * 60.0f, (float)(n2 * 45) / 2.0f);
                generalPath.lineTo((float)n * 180.0f, (float)(n2 * 45) / 2.0f);
                n2 += 2;
            }
            n += 2;
        }
        return generalPath;
    }

    private Shape marks() {
        GeneralPath generalPath = new GeneralPath();
        int n = -1;
        while (n <= 1) {
            int n2 = -1;
            while (n2 <= 1) {
                generalPath.moveTo(n * 2615, (float)(n2 * 183) / 2.0f);
                generalPath.lineTo(n * 2600, (float)(n2 * 183) / 2.0f);
                generalPath.moveTo(n * 2493, (float)(n2 * 252) / 2.0f);
                generalPath.lineTo(n * 2478, (float)(n2 * 252) / 2.0f);
                generalPath.lineTo(n * 2478, (float)n2 * 111.0f);
                n2 += 2;
            }
            n += 2;
        }
        return generalPath;
    }

    public void paintRink(Graphics2D graphics2D) {
        graphics2D.setColor(WHITE);
        graphics2D.fill(this.rink);
        graphics2D.setColor(LIGHTBLUE);
        graphics2D.fill(this.goalAreaA);
        graphics2D.fill(this.goalAreaB);
    }

    public void drawMarkings(Graphics2D graphics2D) {
        graphics2D.setColor(RED);
        graphics2D.setStroke(stroke1);
        graphics2D.draw(this.midLineU);
        graphics2D.draw(this.midLineL);
        graphics2D.setStroke(stroke2);
        graphics2D.draw(this.goalLineA);
        graphics2D.draw(this.goalLineB);
        graphics2D.draw(this.goalArcA);
        graphics2D.draw(this.goalArcB);
        graphics2D.draw(this.goalMarks);
        int n = 0;
        while (n < 4) {
            int n2 = -1;
            while (n2 <= 1) {
                graphics2D.translate(dropX[n], n2 * 1400 / 2);
                graphics2D.fill(this.dropDot);
                if (n < 2) {
                    graphics2D.draw(this.dropCircle);
                    graphics2D.draw(this.dropLines);
                }
                graphics2D.translate(-dropX[n], -n2 * 1400 / 2);
                n2 += 2;
            }
            ++n;
        }
        graphics2D.draw(this.refereeCircle);
        graphics2D.setColor(BLUE);
        graphics2D.setStroke(stroke1);
        graphics2D.fill(this.midDot);
        graphics2D.draw(this.blueLineA);
        graphics2D.draw(this.blueLineB);
        graphics2D.setStroke(stroke2);
        graphics2D.draw(this.dropCircle);
        graphics2D.setColor(BLACK);
        graphics2D.draw(this.rink2);
    }

    private static class RinkOutline
    implements Outline {
        double r;

        public RinkOutline(double d) {
            this.r = d;
        }

        public boolean contains(double d, double d2) {
            double d3 = Math.abs(d) - 3000.0 + 850.0;
            double d4 = Math.abs(d2) - 1500.0 + 850.0;
            return d3 < 0.0 && d4 < 850.0 - this.r || d3 < 850.0 - this.r && d4 < 0.0 || Util.dist(d3, d4) < 850.0 - this.r;
        }

        public double getNormalX(double d, double d2) {
            double d3 = Math.abs(d) - 3000.0 + 850.0;
            double d4 = Math.abs(d2) - 1500.0 + 850.0;
            if (d3 > 0.0) {
                if (d4 > 0.0) {
                    return (double)Util.sign(d) * d3 / Util.dist(d3, d4);
                }
                return Util.sign(d);
            }
            return 0.0;
        }

        public double getNormalY(double d, double d2) {
            double d3 = Math.abs(d) - 3000.0 + 850.0;
            double d4 = Math.abs(d2) - 1500.0 + 850.0;
            if (d4 > 0.0) {
                if (d3 > 0.0) {
                    return (double)Util.sign(d2) * d4 / Util.dist(d3, d4);
                }
                return Util.sign(d2);
            }
            return 0.0;
        }
    }
}

