/*
 * Decompiled with CFR 0.152.
 */
package hockey.tournament;

import hockey.Arena;
import hockey.Loader;
import hockey.Util;
import hockey.api.ITeam;
import hockey.display.Frame;
import hockey.tournament.Match;
import hockey.tournament.TeamEntry;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import javax.swing.JOptionPane;

public class Finals {
    int game;
    String finalsFile;
    TeamEntry[] finalists;
    Match[] quarters;
    Match[] semis;
    Match bronze;
    Match finals;
    Frame frame;

    public Finals(String string, Frame frame) throws FileNotFoundException {
        Object object;
        this.frame = frame;
        this.finalsFile = string;
        this.finalists = new TeamEntry[8];
        this.quarters = new Match[4];
        this.semis = new Match[2];
        this.game = 0;
        FileInputStream fileInputStream = new FileInputStream(string + ".teams");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        String string2 = "";
        int n = 0;
        while (n < 8) {
            try {
                string2 = bufferedReader.readLine();
                object = Loader.loadTeam(string2, false);
                this.finalists[n] = new TeamEntry((ITeam)object, n);
            }
            catch (Exception exception) {
                System.err.println("Failed to load team " + string2);
                exception.printStackTrace();
            }
            if (n % 2 == 1) {
                this.quarters[n / 2] = new Match(this.finalists[n - 1], this.finalists[n]);
            }
            ++n;
        }
        this.semis[0] = new Match(null, null);
        this.semis[1] = new Match(null, null);
        this.bronze = new Match(null, null);
        this.finals = new Match(null, null);
        try {
            int n2;
            int n3;
            object = new FileInputStream(string + ".played");
            StreamTokenizer streamTokenizer = new StreamTokenizer(new InputStreamReader((InputStream)object));
            while ((n3 = Util.readInt(streamTokenizer)) != -1 && (n2 = Util.readInt(streamTokenizer)) != -1) {
                if (this.game < 4) {
                    int n4 = this.game;
                    if (n4 == 1) {
                        n4 = 2;
                    } else if (n4 == 2) {
                        n4 = 1;
                    }
                    this.quarters[n4].setResult(n3, n2);
                } else if (this.game < 6) {
                    this.semis[this.game - 4].setResult(n3, n2);
                } else if (this.game < 7) {
                    this.bronze.setResult(n3, n2);
                } else {
                    this.finals.setResult(n3, n2);
                }
                this.nextGame(null);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private String teamName(TeamEntry teamEntry) {
        if (teamEntry == null) {
            return "-";
        }
        return teamEntry.name;
    }

    private String scoreString(int n, Match match) {
        return match.isPlayed() ? "" + match.getScore(n) : "";
    }

    public String getQuarterFinalist(int n) {
        return this.teamName(this.quarters[n / 2].getTeam(n % 2));
    }

    public String getQuarterScore(int n) {
        return this.scoreString(n % 2, this.quarters[n / 2]);
    }

    public String getSemiFinalist(int n) {
        return this.teamName(this.semis[n / 2].getTeam(n % 2));
    }

    public String getSemiScore(int n) {
        return this.scoreString(n % 2, this.semis[n / 2]);
    }

    public String getFinalist(int n) {
        return this.teamName(this.finals.getTeam(n));
    }

    public String getFinalScore(int n) {
        return this.scoreString(n, this.finals);
    }

    public String getBronze(int n) {
        return this.teamName(this.bronze.getTeam(n));
    }

    public String getBronzeScore(int n) {
        return this.scoreString(n, this.bronze);
    }

    protected void playMatch(Match match, Arena arena) {
        if (match.isPlayed()) {
            return;
        }
        match.play(arena);
        if (match.getScore(0) == match.getScore(1)) {
            int n = JOptionPane.showOptionDialog(this.frame, "Vem vinner?", "Oavgjort", 1, 3, null, new Object[]{"Lag A", "Lag B", "Best\u00e4m sj\u00e4lv"}, "Best\u00e4m sj\u00e4lv");
            System.out.println("Choice: " + n);
            if (n <= 1) {
                match.setScore(n, match.getScore(n) + 1);
            } else {
                TeamEntry.magicLuck = Math.random() * 100000.0;
                if (match.getTeam(0).compareLuck(match.getTeam(1)) < 0) {
                    match.setScore(0, match.getScore(0) + 1);
                } else {
                    match.setScore(1, match.getScore(1) + 1);
                }
            }
        }
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(this.finalsFile + ".played", true));
            printStream.println(match.res1 + " " + match.res2);
            printStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Failed to store result of game!");
        }
    }

    public boolean nextGame(Arena arena) {
        if (this.game < 4) {
            this.playQuarter(this.game, arena);
        } else if (this.game < 6) {
            this.playSemi(this.game - 4, arena);
        } else if (this.game == 6) {
            this.playMatch(this.bronze, arena);
        } else if (this.game == 7) {
            this.playMatch(this.finals, arena);
        } else {
            return false;
        }
        ++this.game;
        return true;
    }

    protected void playQuarter(int n, Arena arena) {
        if (n == 1) {
            n = 2;
        } else if (n == 2) {
            n = 1;
        }
        this.playMatch(this.quarters[n], arena);
        this.semis[n / 2].setTeam(n % 2, this.quarters[n].getWinner());
    }

    protected void playSemi(int n, Arena arena) {
        this.playMatch(this.semis[n], arena);
        this.finals.setTeam(n, this.semis[n].getWinner());
        this.bronze.setTeam(n, this.semis[n].getWinner() == this.semis[n].getTeam(0) ? this.semis[n].getTeam(1) : this.semis[n].getTeam(0));
    }
}

