/*
 * Decompiled with CFR 0.152.
 */
package hockey.tournament;

import hockey.Arena;
import hockey.Loader;
import hockey.Util;
import hockey.api.ITeam;
import hockey.tournament.Match;
import hockey.tournament.ScoreBoard;
import hockey.tournament.TeamEntry;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Vector;

public class Group {
    ScoreBoard scoreBoard;
    String groupFile;
    String groupName;
    Vector teams;
    Vector unplayed;
    Vector played;

    Group(String string) {
        Object object;
        int n;
        Object object2;
        FileInputStream fileInputStream;
        this.groupFile = string;
        this.scoreBoard = new ScoreBoard(this);
        this.groupName = "Group " + string;
        this.teams = new Vector();
        this.unplayed = new Vector();
        this.played = new Vector();
        try {
            int n2;
            int n3;
            String string2;
            fileInputStream = new FileInputStream(string + ".teams");
            object2 = new FileInputStream(string + ".games");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            StreamTokenizer streamTokenizer = new StreamTokenizer(new InputStreamReader((InputStream)object2));
            while ((string2 = bufferedReader.readLine()) != null) {
                try {
                    ITeam iTeam = Loader.loadTeam(string2, false);
                    this.teams.add(new TeamEntry(iTeam, this.teams.size() + 1));
                }
                catch (Exception exception) {
                    System.err.println("Failed to load class " + string2);
                    exception.printStackTrace();
                }
            }
            n = 0;
            while (n < this.teams.size()) {
                int n4 = 0;
                while (n4 < this.teams.size()) {
                    ((TeamEntry)this.teams.get(n)).resolveLuck((TeamEntry)this.teams.get(n4));
                    ++n4;
                }
                ++n;
            }
            while ((n3 = Util.readInt(streamTokenizer)) != -1 && (n2 = Util.readInt(streamTokenizer)) != -1) {
                TeamEntry teamEntry = (TeamEntry)this.teams.get(n3 - 1);
                object = (TeamEntry)this.teams.get(n2 - 1);
                Match match = new Match(teamEntry, (TeamEntry)object);
                this.unplayed.add(match);
            }
            Collections.reverse(this.unplayed);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("File not found: " + fileNotFoundException.getMessage() + "\n");
            return;
        }
        catch (IOException iOException) {
            System.err.println("IOException:");
            iOException.printStackTrace();
            return;
        }
        try {
            int n5;
            int n6;
            int n7;
            fileInputStream = new FileInputStream(string + ".played");
            object2 = new StreamTokenizer(new InputStreamReader(fileInputStream));
            block11: while ((n7 = Util.readInt((StreamTokenizer)object2)) != -1 && (n6 = Util.readInt((StreamTokenizer)object2)) != -1 && (n5 = Util.readInt((StreamTokenizer)object2)) != -1 && (n = Util.readInt((StreamTokenizer)object2)) != -1) {
                TeamEntry teamEntry = (TeamEntry)this.teams.get(n7 - 1);
                TeamEntry teamEntry2 = (TeamEntry)this.teams.get(n6 - 1);
                Match match = new Match(teamEntry, teamEntry2, n5, n);
                this.played.add(match);
                int n8 = this.unplayed.size();
                while (n8-- > 0) {
                    object = (Match)this.unplayed.get(n8);
                    if (((Match)object).team1 == match.team1 && ((Match)object).team2 == match.team2) {
                        this.unplayed.removeElementAt(n8);
                        continue block11;
                    }
                    if (n8 != 0) continue;
                    System.err.println("Warning! unscheduled result " + n7 + " - " + n6 + "  " + n5 + " - " + n);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    boolean nextGame(Arena arena) {
        if (this.unplayed.isEmpty()) {
            return false;
        }
        Match match = (Match)this.unplayed.lastElement();
        this.unplayed.remove(this.unplayed.size() - 1);
        match.play(arena);
        this.played.add(match);
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(this.groupFile + ".played", true));
            printStream.println(match.team1.id + " " + match.team2.id + "   " + match.res1 + " " + match.res2);
            printStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Failed to store result of game!");
        }
        return true;
    }

    void printScoreBoard(PrintStream printStream) {
        this.sortTeams();
        if (this.isFinished()) {
            printStream.println("Final standings in " + this.groupName);
        } else {
            printStream.println("Current standings in " + this.groupName);
        }
        int n = 0;
        while (n < this.teams.size()) {
            ((TeamEntry)this.teams.get(n)).print(printStream);
            ++n;
        }
        printStream.println("");
    }

    void printGameHistory(PrintStream printStream) {
        int n = 0;
        while (n < this.played.size()) {
            ((Match)this.played.get(n)).print(printStream);
            ++n;
        }
    }

    ScoreBoard getScoreBoard() {
        return this.scoreBoard;
    }

    String getName() {
        return this.groupName;
    }

    boolean isFinished() {
        return this.unplayed.isEmpty();
    }

    int getTeams() {
        return this.teams.size();
    }

    TeamEntry getTeam(int n) {
        return (TeamEntry)this.teams.get(n);
    }

    int teamIndex(TeamEntry teamEntry) {
        int n = 0;
        while (n < this.teams.size()) {
            if (teamEntry == this.teams.get(n)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    void sortTeams() {
        Collections.sort(this.teams);
        int n = this.teams.size();
        int n2 = this.played.size();
        int n3 = 0;
        while (n3 < n) {
            TeamEntry teamEntry = (TeamEntry)this.teams.get(n3);
            int n4 = n3 + 1;
            while (n4 < n && ((TeamEntry)this.teams.get(n4)).score() == teamEntry.score()) {
                ++n4;
            }
            if (n4 - n3 > 1 && n4 - n3 <= n) {
                int n5;
                int n6;
                Object[] objectArray = new TeamEntry[n4 - n3];
                int n7 = 0;
                while (n7 < n4 - n3) {
                    objectArray[n7] = new TeamEntry(n7);
                    ++n7;
                }
                int n8 = 0;
                while (n8 < n2) {
                    Match match = (Match)this.played.get(n8);
                    if (teamEntry.score() == match.team1.score() && teamEntry.score() == match.team2.score()) {
                        n6 = this.teamIndex(match.team1) - n3;
                        n5 = this.teamIndex(match.team2) - n3;
                        new Match((TeamEntry)objectArray[n6], (TeamEntry)objectArray[n5], match.res1, match.res2);
                    }
                    ++n8;
                }
                Arrays.sort(objectArray);
                int n9 = 0;
                while (n9 < n4 - n3) {
                    n6 = n9 + 1;
                    while (n6 < n4 - n3 && ((TeamEntry)objectArray[n9]).compareNoLuck((TeamEntry)objectArray[n6]) == 0) {
                        ++n6;
                    }
                    n5 = n9;
                    while (n5 < n6) {
                        objectArray[n5] = (TeamEntry)this.teams.get(n3 + ((TeamEntry)objectArray[n5]).id);
                        ++n5;
                    }
                    Arrays.sort(objectArray, n9, n6);
                    n9 = n6 - 1;
                    ++n9;
                }
                n6 = 0;
                while (n6 < n4 - n3) {
                    this.teams.setElementAt(objectArray[n6], n3 + n6);
                    ++n6;
                }
            }
            n3 = n4 - 1;
            ++n3;
        }
    }
}

