/*
 * Decompiled with CFR 0.152.
 */
package hockey.tournament;

import hockey.api.ITeam;
import java.io.PrintStream;

public class TeamEntry
implements Comparable {
    public static double magicLuck;
    public ITeam team;
    public String name;
    public int lucky;
    public int wins;
    public int draws;
    public int losses;
    public int goodGoals;
    public int badGoals;
    public int id;

    TeamEntry(ITeam iTeam, int n) {
        this.team = iTeam;
        this.id = n;
        this.lucky = iTeam.getLuckyNumber();
        this.name = iTeam.getTeamName();
        this.badGoals = 0;
        this.goodGoals = 0;
        this.losses = 0;
        this.draws = 0;
        this.wins = 0;
    }

    TeamEntry(int n) {
        this.id = n;
        this.badGoals = 0;
        this.goodGoals = 0;
        this.losses = 0;
        this.draws = 0;
        this.wins = 0;
        this.lucky = 0;
    }

    public int score() {
        return 2 * this.wins + this.draws;
    }

    public int games() {
        return this.wins + this.draws + this.losses;
    }

    public int goalDiff() {
        return this.goodGoals - this.badGoals;
    }

    public void print(PrintStream printStream) {
        printStream.print(this.name);
        int n = this.name.length();
        while (n < 30) {
            printStream.print(" ");
            ++n;
        }
        printStream.println(" " + this.games() + " " + this.wins + " " + this.draws + " " + this.losses + " " + this.goodGoals + "-" + this.badGoals + " " + this.score());
    }

    public void resolveLuck(TeamEntry teamEntry) {
        if (this.lucky == teamEntry.lucky) {
            teamEntry.lucky = (teamEntry.lucky + 1) % 100000;
        }
    }

    public int compareLuck(TeamEntry teamEntry) {
        if (this.lucky != teamEntry.lucky) {
            return Math.abs(Math.IEEEremainder((double)this.lucky - magicLuck, 100000.0)) < Math.abs(Math.IEEEremainder((double)teamEntry.lucky - magicLuck, 100000.0)) ? -1 : 1;
        }
        return Math.random() < 0.5 ? -1 : 1;
    }

    public int compareNoLuck(TeamEntry teamEntry) {
        if (this.score() != teamEntry.score()) {
            return teamEntry.score() - this.score();
        }
        if (this.goalDiff() != teamEntry.goalDiff()) {
            return teamEntry.goalDiff() - this.goalDiff();
        }
        if (this.goodGoals != teamEntry.goodGoals) {
            return teamEntry.goodGoals - this.goodGoals;
        }
        return 0;
    }

    public int compareTo(Object object) {
        TeamEntry teamEntry = (TeamEntry)object;
        int n = this.compareNoLuck(teamEntry);
        if (n != 0) {
            return n;
        }
        return this.compareLuck(teamEntry);
    }
}

