package samples;

import java.awt.Color;
import hockey.api.GoalKeeper;
import hockey.api.IPlayer;
import hockey.api.Player;
import hockey.api.ITeam;
import hockey.api.Util;

public class Bullies implements ITeam {
    public String getShortName() { return "BUS"; }
    public String getTeamName() { return "Busarna"; }
    public Color getTeamColor() { return Color.GREEN; }
    public Color getSecondaryTeamColor() { return Color.YELLOW; }
    public int getLuckyNumber() { return 13; }
    public GoalKeeper getGoalKeeper() { return new BullieGoalie(); }
    public Player getPlayer(int index) {
	return new Bullie(index);
    }
}

class Bullie extends Player {
    private static int[] numbers = {1, 2, 3, 4, 5, 6};
    private static String[] names = {
	"", "Biffen", "Doris", "Harry", "Vanheden", "Sickan"
    };
    private int index;

    public Bullie(int index) { this.index = index; }
    public int getNumber() { return numbers[index]; }
    public String getName() { return names[index]; }
    public boolean isLeftHanded() { return false; }
    public void step() {
	if (hasPuck()) // Om vi har pucken
	    skate(2600, 0, 1000); // k mot ml
	else if (Util.dist(getX() - getPuck().getX(), // Om pucken r inom 5m 
			   getY() - getPuck().getY()) < 500)
	    skate(getPuck(), 1000); // Hmta pucken                  
	else {
	    IPlayer best = null;
	    for (int i = 0; i < 12; ++i) { // G igenom alla spelare
		IPlayer cur = getPlayer(i);

		if (cur.isOpponent() && // Om spelaren r en motspelare...
		    (best == null || 
		     Util.dist(getX() - cur.getX(), // ...och nrmast hittils
			       getY() - cur.getY()) <
		     Util.dist(getX() - best.getX(),
			       getY() - best.getY())))
		    best = cur; // Spara honom
	    }

	    skate(best, 1000); // Tackla nrmaste spelare
	}
    }
}

class BullieGoalie extends GoalKeeper {
    public int getNumber() { return 1; }
    public String getName() { return "Franz Jaeger"; }
    public boolean isLeftHanded() { return false; }
    public void step() {
	skate(-2550, 0, 200); // St mitt i mlet, m framfr
	turn(getPuck(), MAX_TURN_SPEED); // Vnd mot pucken
    }
}

