package samples;

import java.awt.Color;
import hockey.api.GoalKeeper;
import hockey.api.Player;
import hockey.api.ITeam;
import hockey.api.Util;

public class TriggerHappy implements ITeam {
    public String getShortName() { return "PNG"; }
    public String getTeamName() { return "De skjutglada"; }
    public Color getTeamColor() { return Color.BLACK; }
    public Color getSecondaryTeamColor() { return Color.RED; }
    public int getLuckyNumber() { return 13; }
    public GoalKeeper getGoalKeeper() { return new ShooterGoalie(); }
    public Player getPlayer(int index) {
	return new Shooter(index);
    }
}

class Shooter extends Player {
    private static int[] numbers = {1, 2, 3, 4, 5, 6};
    private static String[] names = {
	"", "Glock", "Ruger", "Smith", "Wesson", "Colt"
    };
    private int index;

    public Shooter(int index) { this.index = index; }
    public int getNumber() { return numbers[index]; }
    public String getName() { return names[index]; }
    public boolean isLeftHanded() { return false; }
    public void step() {
	if (hasPuck()) // Om vi har pucken...
	    if (Math.abs(Util.dangle(getHeading(), // ...och r vnda mot ml
				     Util.datan2(0 - getY(),
						 2500 - getX()))) < 90) {
		int target = (int)(Math.random()*200)-100;
		shoot(2600, target, 10000); // Skjut
	    } else // Annars
		skate(2600, 0, 1000); // k mot ml
	else // Annars
	    skate(getPuck(), 1000); // Hmta pucken
    }
}

class ShooterGoalie extends GoalKeeper {
    public int getNumber() { return 1; }
    public String getName() { return "Beretta"; }
    public boolean isLeftHanded() { return false; }
    public void step() {
	if (hasPuck()) // Om vi har pucken
	    shoot(2600, 0, 10000); // Skjut (eller kasta)
	skate(-2550, 0, 200); // St mitt i mlet, m framfr
	turn(getPuck(), MAX_TURN_SPEED); // St mitt i mlet, m framfr
    }
}
